/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.engine.workitem.AtomicAttribute;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class XmlAttribute
extends AtomicAttribute {
    static final long serialVersionUID = -8126080886117226443L;
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$workitem$XmlAttribute == null ? (class$openwfe$org$engine$workitem$XmlAttribute = XmlAttribute.class$("openwfe.org.engine.workitem.XmlAttribute")) : class$openwfe$org$engine$workitem$XmlAttribute).getName());
    static /* synthetic */ Class class$openwfe$org$engine$workitem$XmlAttribute;

    public XmlAttribute() {
        super(null);
    }

    public XmlAttribute(Content c) {
        super(c);
    }

    public Content getContent() {
        return (Content)this.getValue();
    }

    public String toString() {
        if (this.getValue() == null) {
            return "";
        }
        String s = XmlUtils.xmlToString((Content)this.getContent());
        return XmlUtils.removeHeaderLine((String)s);
    }

    public Object clone() {
        if (this.getValue() == null) {
            return new XmlAttribute();
        }
        return new XmlAttribute((Content)this.getContent().clone());
    }

    public Attribute getAttributeContent(ApplicationContext context) {
        Attribute a;
        block3: {
            if (!(this.getContent() instanceof Element)) {
                return null;
            }
            XmlWorkItemCoder coder = Definitions.getXmlCoder(context);
            a = null;
            try {
                a = coder.decodeAttribute((Element)this.getContent());
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("getAttributeContent() no attribute in " + XmlUtils.xmlToString((Content)this.getContent())));
            }
        }
        return a;
    }

    private static int fetchIndex(String key) {
        int childId = -1;
        try {
            childId = Integer.parseInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return childId;
    }

    private static Content lookupChild(String key, Element elt) {
        int childId = XmlAttribute.fetchIndex(key);
        if (childId > -1) {
            if (childId > elt.getChildren().size() - 1) {
                return null;
            }
            return (Content)elt.getChildren().get(childId);
        }
        return elt.getChild(key);
    }

    private static Content lookupContent(String key, Element elt) {
        int childId = XmlAttribute.fetchIndex(key);
        if (childId < 0) {
            return null;
        }
        if (childId > elt.getContent().size() - 1) {
            return null;
        }
        return (Content)elt.getContent().get(childId);
    }

    private static Content lookupItem(String key, Element elt) {
        char c0 = key.charAt(0);
        Character c1 = null;
        if (key.length() > 1) {
            c1 = new Character(key.charAt(1));
        }
        if (Character.isDigit(c0)) {
            return XmlAttribute.lookupContent(key, elt);
        }
        if (c1 == null && Character.isDigit(c0)) {
            return XmlAttribute.lookupContent(key, elt);
        }
        if (c1 == null && Character.isLetter(c0)) {
            return XmlAttribute.lookupChild(key, elt);
        }
        if (c0 == 'e' && Character.isDigit(c1.charValue())) {
            return XmlAttribute.lookupChild(key.substring(1), elt);
        }
        if (c0 == '@') {
            String sValue = elt.getAttributeValue(key.substring(1));
            if (sValue == null) {
                return null;
            }
            return new Text(sValue);
        }
        return XmlAttribute.lookupChild(key, elt);
    }

    public static Content lookupInXml(String key, Content c) {
        Content cCar;
        if (key.equals("/") || key.equals("")) {
            return (Content)c.clone();
        }
        if (!(c instanceof Element)) {
            return null;
        }
        Element e = (Element)c;
        int i = key.indexOf(".");
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookupInXml() i = " + i));
        }
        if (i < 0) {
            return XmlAttribute.lookupItem(key, e);
        }
        String scar = key.substring(0, i);
        String scdr = key.substring(i + 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookupInXml() car >" + scar + "<   cdr >" + scdr + "<"));
        }
        if (!((cCar = XmlAttribute.lookupItem(scar, e)) instanceof Element)) {
            return null;
        }
        Element eCar = (Element)cCar;
        if (scdr.equals("")) {
            return new Text(eCar.getText());
        }
        return XmlAttribute.lookupInXml(scdr, (Content)((Element)cCar));
    }

    private static Attribute toAttribute(Content c) {
        if (c == null) {
            return null;
        }
        if (c instanceof Text) {
            return new StringAttribute(((Text)c).getText());
        }
        return new XmlAttribute((Content)c.clone());
    }

    public static Attribute lookupAsAttribute(String key, Content c) {
        return XmlAttribute.toAttribute(XmlAttribute.lookupInXml(key, c));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

