/*
 * Copyright (c) 2006, Nicolas Modrzyk and John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ReflectionUtils.java 2673 2006-05-26 21:08:46Z jmettraux $
 */

//
// JcrProxy.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.jcr;

import java.lang.reflect.Proxy;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import openwfe.org.util.ReflectionUtils;


/**
 * Wrapping real JCR classes with a proxy...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author$
 * <br>$Id$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class JcrProxy
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(JcrProxy.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // CONSTRUCTORS

    private JcrProxy ()
    {
        super();
    }

    //
    // STATIC METHODS

    public static Object wrap (final Object o)
    {
        if (o == null) return null;

        if (o instanceof javax.jcr.Node)
            return wrap(Node.class, o);

        if (o instanceof javax.jcr.Property)
            return wrap(Property.class, o);

        if (o instanceof javax.jcr.Value)
            return wrap(Value.class, o);

        //
        // else

        return o;
    }

    public static Object wrap (final Class targetClass, final Object o)
    {
        return Proxy.newProxyInstance
            (targetClass.getClassLoader(),
             new Class[] { targetClass },
             new SameMethodNameProxy(o));
    }

    public static Node wrapJcrNode (final javax.jcr.Node n)
    {
        return (Node)wrap(Node.class, n);
    }

    public static Property wrapJcrProperty (final javax.jcr.Property p)
    {
        return (Property)wrap(Property.class, p);
    }

    public static Value wrapJcrValue (final javax.jcr.Value v)
    {
        return (Value)wrap(Value.class, v);
    }

    //
    // INNER CLASSES

    private static class SameMethodNameProxy 
        implements InvocationHandler
    {
        private Object wrappedInstance = null;

        public SameMethodNameProxy (final Object wrappedInstance)
        {
            super();
            this.wrappedInstance = wrappedInstance;
        }

        public Object invoke 
            (final Object proxy,
             final Method m,
             final Object[] args)
        throws
            Throwable
        {
            if (m.equals("getWrappedInstance"))
            {
                return this.wrappedInstance;
            }

            if (m.getName().equals("getValue") &&
                (wrappedInstance instanceof javax.jcr.Value))
            {
                return JcrValueUtils
                    .toObject((javax.jcr.Value)wrappedInstance);
            }

            Object result = null;

            /*
            try
            {
                result = ReflectionUtils.invoke
                    (this.wrappedInstance,
                     m.getName(),
                     toClassArray(args),
                     args);
            }
            catch (final javax.jcr.RepositoryException e)
            {
                throw new JcrException
                    ("call to method "+m.getName()+"() failed", e);
            }
            */

            Throwable throwable = null;
            try
            {
                final Method wrappedMethod = findMethod
                    (this.wrappedInstance,
                     m.getName(),
                     args);

                result = wrappedMethod.invoke(this.wrappedInstance, args);
            }
            catch (final InvocationTargetException ite)
            {
                throwable = ite.getCause();
            }
            catch (final Exception e)
            {
                throwable = e;
            }

            if (throwable != null)
            {
                throw new JcrException
                    ("call to method "+m.getName()+"() failed", throwable);
            }

            return wrap(result);
        }

        /*
         * JCR instance methods are not too varied, the
         * tactic implemented here is sufficient.
         */
        private static Method findMethod 
            (final Object target,
             final String methodName,
             final Object[] args)
        {
            final Method[] ms = target.getClass().getMethods();

            for (int i=0; i<ms.length; i++)
            {
                if ( ! ms[i].getName().equals(methodName)) continue;

                if (ms[i].getParameterTypes().length != args.length) continue;

                /*
                boolean wrongArgs = false;

                for (int j=0; j<args.length; j++)
                {
                    if (args[j] == null) continue;

                    if ( ! args[j].getClass().equals
                            (ms[i].getParameterTypes()[j]))
                    {
                        wrongArgs = true;
                        break;
                    }
                }

                if (wrongArgs) continue;
                */

                return ms[i];
            }

            throw new IllegalArgumentException
                ("couldn't find a suitable method named '"+methodName+
                 "' in class "+target.getClass().getName());
        }

        /* 
         * ineffective with nulls in the argArray...
         *
        private static Class[] toClassArray (final Object[] argArray)
        {
            final Class[] result = new Class[argArray.length];

            for (int i=0; i<argArray.length; i++)
                result[i] = argArray[i].getClass();

            return result;
        }
         */
    }

}
