/*
 * Copyright (c) 2006, Nicolas Modrzyk and John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ReflectionUtils.java 2673 2006-05-26 21:08:46Z jmettraux $
 */

//
// JcrValueUtils.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.jcr;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;

//import openwfe.org.util.ReflectionUtils;


/**
 * Tools for working with javax.jcr.Value instances.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author$
 * <br>$Id$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class JcrValueUtils
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(JcrValueUtils.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // CONSTRUCTORS

    private JcrValueUtils ()
    {
        super();
    }

    //
    // STATIC METHODS

    public static Object toObject (final javax.jcr.Value v)
        throws JcrException
    {
        final int t = v.getType();

        try
        {
            if (t == PropertyType.STRING) return v.getString();
            if (t == PropertyType.DATE) return v.getDate();
            if (t == PropertyType.BINARY) return v.getStream();
            if (t == PropertyType.DOUBLE) return new Double(v.getDouble());
            if (t == PropertyType.LONG) return new Long(v.getLong());
            if (t == PropertyType.BOOLEAN) return new Boolean(v.getBoolean());
        }
        catch (final RepositoryException e)
        {
            throw new JcrException("problem with the value");
        }

        throw new IllegalArgumentException
            ("cannot handle javax.jcr.Value of type "+t);
    }

    public static int getJcrType (final Object value)
        throws JcrException
    {
        if (value instanceof String) return PropertyType.STRING;

        if (value instanceof java.util.Date) return PropertyType.DATE;
        if (value instanceof java.util.Calendar) return PropertyType.DATE;

        if (value instanceof byte[]) return PropertyType.BINARY;

        if (value instanceof Double) return PropertyType.DOUBLE;
        if (value instanceof Float) return PropertyType.DOUBLE;

        if (value instanceof Long) return PropertyType.LONG;
        if (value instanceof Integer) return PropertyType.LONG;

        if (value instanceof Boolean) return PropertyType.BOOLEAN;

        throw new JcrException
            ("value of class "+value.getClass().getName()+
             "cannot get mapped to a JCR property type");
    }

}
