/*
 * Copyright (c) 2006, Nicolas Modrzyk and John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ReflectionUtils.java 2673 2006-05-26 21:08:46Z jmettraux $
 */

//
// MockNode.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.jcr.mock;

import javax.jcr.PropertyType;

import openwfe.org.jcr.Item;
import openwfe.org.jcr.Node;
import openwfe.org.jcr.Value;
import openwfe.org.jcr.Property;
import openwfe.org.jcr.JcrException;


/**
 * Mocking a Node.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author$
 * <br>$Id$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class MockNode

    extends MockItem

    implements Node

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MockNode.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private java.util.Map nodes = null;
    private java.util.Map properties = null;

    //
    // CONSTRUCTORS

    public MockNode (final String name)
    {
        this(null, name);
    }

    public MockNode (final Item parent, final String name)
    {
        super(parent, name);

        this.nodes = new java.util.LinkedHashMap();
        this.properties = new java.util.LinkedHashMap();
    }

    //
    // METHODS from Item

    public boolean isNode ()
        throws JcrException
    {
        return true;
    }

    //
    // METHODS from Node

    public boolean hasProperty (final String propertyName)
        throws JcrException
    {
        //log.debug("hp() '"+this.getPath()+"' - '"+propertyName+"' ?");

        return this.properties.containsKey(propertyName);
    }

    public Property getProperty (final String propertyName)
        throws JcrException
    {
        //log.debug("gp() '"+this.getPath()+"' - '"+propertyName+"'");

        return (Property)this.properties.get(propertyName);
    }

    public java.util.Iterator getNodes ()
    {
        return this.nodes.values().iterator();
    }

    public java.util.Iterator getProperties ()
    {
        return this.properties.values().iterator();
    }

    public Property setProperty 
        (final String propertyName, final String value)
    throws 
        JcrException
    {
        return setProperty(propertyName, value, PropertyType.STRING);
    }

    public Property setProperty 
        (final String propertyName, final String value, final int type)
    throws 
        JcrException
    {
        final Property p = new MockProperty
            (this, propertyName, new MockValue(value, type));

        this.properties.put(propertyName, p);

        return p;
    }

    public Property setProperty 
        (final String propertyName, final java.io.InputStream value)
    throws 
        JcrException
    {
        final Property p = new MockProperty
            (this, propertyName, new MockValue(value));

        this.properties.put(propertyName, p);

        return p;
    }

    public boolean hasNode (final String relPath)
        throws JcrException
    {
        //log.debug("hn() '"+this.getPath()+"' - '"+relPath+"' ?");

        return this.nodes.containsKey(relPath);
    }

    public Node getNode (final String relPath)
        throws JcrException
    {
        //log.debug("gn() '"+this.getPath()+"' - '"+relPath+"'");

        return (Node)this.nodes.get(relPath);
    }

    public Node addNode (final String newNodeName)
        throws JcrException
    {
        final Node n = new MockNode(this, newNodeName);

        this.nodes.put(newNodeName, n);

        return n;
    }

    public void remove ()
        throws JcrException
    {
        if (this.getParent() != null)
            ((MockNode)this.getParent()).nodes.remove(this);
    }

    //
    // METHODS

    public String render (int depth)
        throws JcrException
    {
        final StringBuffer sb = new StringBuffer();

        sb.append(renderIndent(depth));

        sb.append("n: '").append(this.getName()).append("'");
        sb.append("\n");

        java.util.Iterator it = this.properties.values().iterator();
        while(it.hasNext())
            sb.append(((MockItem)it.next()).render(depth+1));

        it = this.nodes.values().iterator();
        while(it.hasNext())
            sb.append(((MockItem)it.next()).render(depth+1));

        return sb.toString();
    }

    //
    // STATIC METHODS

}
