/*
 * Copyright (c) 2006, Nicolas Modrzyk and John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ReflectionUtils.java 2673 2006-05-26 21:08:46Z jmettraux $
 */

//
// MockProperty.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.jcr.mock;

//import javax.jcr.PropertyType;

import openwfe.org.jcr.Item;
import openwfe.org.jcr.Value;
import openwfe.org.jcr.Property;
import openwfe.org.jcr.JcrException;


/**
 * Mocking a Property...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author$
 * <br>$Id$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class MockProperty

    extends MockItem

    implements Property

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MockProperty.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private Value value = null;

    //
    // CONSTRUCTORS

    public MockProperty 
        (final Item parent, 
         final String name, 
         final Value v)
    {
        super(parent, name);

        this.value = v;
    }

    //
    // METHODS from Item

    public boolean isNode ()
        throws JcrException
    {
        return false;
    }

    //
    // METHODS from Property

    public Value getValue ()
        throws JcrException
    {
        return this.value;
    }

    public String getString ()
        throws JcrException
    {
        return this.value.getString();
    }

    public long getLong ()
        throws JcrException
    {
        return this.value.getLong();
    }

    public java.io.InputStream getStream ()
        throws JcrException
    {
        return this.value.getStream();
    }

    //
    // METHODS from MockItem

    public String render (final int depth)
        throws JcrException
    {
        final StringBuffer sb = new StringBuffer();

        sb.append(renderIndent(depth));

        sb
            .append("p: '")
            .append(this.getName())
            .append("' -> '")
            .append(this.getValue().toString())
            .append("'")
            .append("\n");

        return sb.toString();
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
