/*
 * Copyright (c) 2006, Nicolas Modrzyk and John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ReflectionUtils.java 2673 2006-05-26 21:08:46Z jmettraux $
 */

//
// MockValue.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.jcr.mock;

import javax.jcr.PropertyType;

import openwfe.org.misc.Base64;
import openwfe.org.misc.ByteUtils;
import openwfe.org.jcr.Value;
import openwfe.org.jcr.JcrException;


/**
 * Dummy value...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author$
 * <br>$Id$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class MockValue

    implements Value

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MockValue.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private int type = PropertyType.STRING;
    private Object value = null;

    //
    // CONSTRUCTORS

    public MockValue (final Object val)
    {
        super();

        this.value = val.toString();
    }

    public MockValue (final Object val, final int type)
    {
        super();

        this.type = type;
        this.value = val;
    }

    public MockValue (final java.io.InputStream val)
        throws JcrException
    {
        super();

        this.type = PropertyType.BINARY;

        try
        {
            final java.io.ByteArrayOutputStream baos = 
                new java.io.ByteArrayOutputStream();

            ByteUtils.copy(val, baos, 1024);

            this.value = baos.toByteArray();
        }
        catch (final java.io.IOException ie)
        {
            throw new JcrException
                ("failed to fetch data from input stream", ie);
        }
    }

    //
    // METHODS from Value

    public String getString ()
        throws JcrException
    {
        try
        {
            return (String)value;
        }
        catch (final Throwable t)
        {
            throw new JcrException("contained value is not a String", t);
        }
    }

    public long getLong ()
        throws JcrException
    {
        if (this.value instanceof Long)
            return ((Long)this.value).longValue();

        try
        {
            return Long.parseLong(this.value.toString());
        }
        catch (final Throwable t)
        {
            throw new JcrException("contained value is not a long", t);
        }
    }

    public java.io.InputStream getStream ()
        throws JcrException
    {
        if ( ! (this.value instanceof byte[]))
        {
            throw new JcrException
                ("contained value is not returnable as a stream");
        }

        return new java.io.ByteArrayInputStream((byte[])this.value);
    }

    public int getType ()
    {
        return this.type;
    }

    public Object getValue ()
        throws JcrException
    {
        return this.value;
    }

    public Object getWrappedInstance ()
        throws JcrException
    {
        return null;
    }

    //
    // METHODS

    public String toString ()
    {
        if (this.value instanceof byte[])
            return new String(Base64.encode((byte[])this.value));

        return this.value.toString();
    }

    //
    // STATIC METHODS

}
