/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.jcr;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import openwfe.org.jcr.JcrException;
import openwfe.org.jcr.JcrValueUtils;
import openwfe.org.jcr.Node;
import openwfe.org.jcr.Property;
import openwfe.org.jcr.Value;

public abstract class JcrProxy {
    private JcrProxy() {
    }

    public static Object wrap(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof javax.jcr.Node) {
            return JcrProxy.wrap(Node.class, o);
        }
        if (o instanceof javax.jcr.Property) {
            return JcrProxy.wrap(Property.class, o);
        }
        if (o instanceof javax.jcr.Value) {
            return JcrProxy.wrap(Value.class, o);
        }
        return o;
    }

    public static Object wrap(Class targetClass, Object o) {
        return Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, (InvocationHandler)new SameMethodNameProxy(o));
    }

    public static Node wrapJcrNode(javax.jcr.Node n) {
        return (Node)JcrProxy.wrap(Node.class, n);
    }

    public static Property wrapJcrProperty(javax.jcr.Property p) {
        return (Property)JcrProxy.wrap(Property.class, p);
    }

    public static Value wrapJcrValue(javax.jcr.Value v) {
        return (Value)JcrProxy.wrap(Value.class, v);
    }

    private static class SameMethodNameProxy
    implements InvocationHandler {
        private Object wrappedInstance = null;

        public SameMethodNameProxy(Object wrappedInstance) {
            this.wrappedInstance = wrappedInstance;
        }

        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            if (m.equals("getWrappedInstance")) {
                return this.wrappedInstance;
            }
            if (m.getName().equals("getValue") && this.wrappedInstance instanceof javax.jcr.Value) {
                return JcrValueUtils.toObject((javax.jcr.Value)this.wrappedInstance);
            }
            Object result = null;
            Throwable throwable = null;
            try {
                Method wrappedMethod = SameMethodNameProxy.findMethod(this.wrappedInstance, m.getName(), args);
                result = wrappedMethod.invoke(this.wrappedInstance, args);
            }
            catch (InvocationTargetException ite) {
                throwable = ite.getCause();
            }
            catch (Exception e) {
                throwable = e;
            }
            if (throwable != null) {
                throw new JcrException("call to method " + m.getName() + "() failed", throwable);
            }
            return JcrProxy.wrap(result);
        }

        private static Method findMethod(Object target, String methodName, Object[] args) {
            Method[] ms = target.getClass().getMethods();
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(methodName) || ms[i].getParameterTypes().length != args.length) continue;
                return ms[i];
            }
            throw new IllegalArgumentException("couldn't find a suitable method named '" + methodName + "' in class " + target.getClass().getName());
        }
    }
}

