/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.jcr;

import java.util.Calendar;
import java.util.Date;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import openwfe.org.jcr.JcrException;

public abstract class JcrValueUtils {
    private JcrValueUtils() {
    }

    public static Object toObject(Value v) throws JcrException {
        int t = v.getType();
        try {
            if (t == 1) {
                return v.getString();
            }
            if (t == 5) {
                return v.getDate();
            }
            if (t == 2) {
                return v.getStream();
            }
            if (t == 4) {
                return new Double(v.getDouble());
            }
            if (t == 3) {
                return new Long(v.getLong());
            }
            if (t == 6) {
                return new Boolean(v.getBoolean());
            }
        }
        catch (RepositoryException e) {
            throw new JcrException("problem with the value");
        }
        throw new IllegalArgumentException("cannot handle javax.jcr.Value of type " + t);
    }

    public static int getJcrType(Object value) throws JcrException {
        if (value instanceof String) {
            return 1;
        }
        if (value instanceof Date) {
            return 5;
        }
        if (value instanceof Calendar) {
            return 5;
        }
        if (value instanceof byte[]) {
            return 2;
        }
        if (value instanceof Double) {
            return 4;
        }
        if (value instanceof Float) {
            return 4;
        }
        if (value instanceof Long) {
            return 3;
        }
        if (value instanceof Integer) {
            return 3;
        }
        if (value instanceof Boolean) {
            return 6;
        }
        throw new JcrException("value of class " + value.getClass().getName() + "cannot get mapped to a JCR property type");
    }
}

