/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.jcr.beancoder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.PropertyType;
import openwfe.org.jcr.Item;
import openwfe.org.jcr.JcrException;
import openwfe.org.jcr.JcrProxy;
import openwfe.org.jcr.JcrValueUtils;
import openwfe.org.jcr.Node;
import openwfe.org.jcr.Property;
import openwfe.org.jcr.Value;
import openwfe.org.misc.ByteUtils;
import openwfe.org.util.beancoder.AbstractBeanCoder;
import openwfe.org.util.beancoder.BeanCoderException;
import openwfe.org.util.beancoder.BeanCoderUtils;
import org.apache.log4j.Logger;

public class JcrBeanCoder
extends AbstractBeanCoder {
    private static final Logger log = Logger.getLogger((String)JcrBeanCoder.class.getName());
    public static final String PN_SIZE = "size";
    public static final String PN_PVALUE = "pvalue";
    public static final String PN_CLASS = JcrBeanCoder.class.getName() + "__" + "instance_class";
    public static final String NN_ENTRY = "map-entry";
    public static final String C_NULL = "Null";
    public static final String V_NULL = "null";
    private String nsp = "";
    private Item previousItem = null;
    private Item currentItem = null;
    private String currentItemName = null;
    private long currentLocalId = -1L;
    private boolean override = true;
    private boolean overrideDone = false;

    public JcrBeanCoder(String ns, Node startNode) {
        this(ns, startNode, null);
    }

    public JcrBeanCoder(String ns, Node startNode, String beanNodeName) {
        if (ns != null) {
            this.nsp = ns + ":";
        }
        this.currentItem = startNode;
        this.currentItemName = beanNodeName;
    }

    public void setOverrideNode(boolean b) {
        this.override = b;
    }

    public boolean getOverrideNode() {
        return this.override;
    }

    protected Node currentNode() {
        return (Node)this.currentItem;
    }

    protected Property currentProperty() {
        return (Property)this.currentItem;
    }

    protected void beginElement() throws BeanCoderException {
        if (this.currentItemName == null) {
            return;
        }
        this.currentItem = this.currentNode().addNode(this.currentItemName);
        this.currentItemName = null;
    }

    protected long getUniqueLocalId() {
        ++this.currentLocalId;
        return this.currentLocalId;
    }

    protected int currentType() throws BeanCoderException {
        Class c;
        if (this.currentItem instanceof Property) {
            return 4;
        }
        String className = this.currentClassName();
        if (className == null) {
            if (this.currentNode().hasProperty(this.nsp + PN_SIZE)) {
                return 0;
            }
            throw new JcrException("property 'class' is missing (" + this.currentItem.getPath() + ")");
        }
        if (className.equals(C_NULL)) {
            return -1;
        }
        if (Map.class.isAssignableFrom(c = this.currentClass())) {
            return 2;
        }
        if (Collection.class.isAssignableFrom(c)) {
            return 3;
        }
        return 5;
    }

    protected Class currentPrimitiveClass() throws BeanCoderException {
        Value v = null;
        String s = null;
        v = this.currentProperty().getValue();
        if (v.getType() == 1) {
            return String.class;
        }
        if (v.getType() == 6) {
            return Boolean.class;
        }
        if (v.getType() == 5) {
            return Date.class;
        }
        if (v.getType() == 2) {
            return [B.class;
        }
        s = v.toString();
        if (v.getType() == 4) {
            if (s.endsWith("f")) {
                return Float.class;
            }
            return Double.class;
        }
        if (v.getType() == 3) {
            if (s.endsWith("l")) {
                return Long.class;
            }
            return Integer.class;
        }
        throw new JcrException("cannot handle property of type '" + PropertyType.nameFromValue((int)v.getType()) + "'");
    }

    protected String currentClassName() throws BeanCoderException {
        if (!this.currentItem.isNode()) {
            return this.currentPrimitiveClass().getName();
        }
        if (!this.currentNode().hasProperty(this.nsp + PN_CLASS)) {
            return null;
        }
        return this.currentNode().getProperty(this.nsp + PN_CLASS).getString();
    }

    protected Class currentClass() throws BeanCoderException {
        if (!this.currentItem.isNode()) {
            return this.currentPrimitiveClass();
        }
        String className = null;
        try {
            className = this.currentNode().getProperty(this.nsp + PN_CLASS).getString();
            return Class.forName(className);
        }
        catch (JcrException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new BeanCoderException("failed to find class named '" + className + "'", t);
        }
    }

    protected int subElementCount() throws BeanCoderException {
        return (int)this.currentNode().getProperty(this.nsp + PN_SIZE).getLong();
    }

    protected Iterator subElementIterator() throws BeanCoderException {
        int type = this.currentType();
        if (type == 0 || type == 3) {
            return new IndexedIterator(this.currentNode());
        }
        return new ItemIterator(this.currentNode());
    }

    protected String currentFieldName() throws BeanCoderException {
        return this.currentItem.getName();
    }

    protected String currentText() throws BeanCoderException {
        return this.currentProperty().getString();
    }

    protected Object decodeBean() throws BeanCoderException {
        if (this.currentNode().hasProperty(this.nsp + PN_PVALUE)) {
            return BeanCoderUtils.newPrimitive((Class)this.currentClass(), (String)this.currentNode().getProperty(this.nsp + PN_PVALUE).getString());
        }
        return super.decodeBean();
    }

    protected Object decodeFieldValue() throws BeanCoderException {
        if (!this.currentItem.isNode()) {
            return this.decodePrimitive();
        }
        return this.decode();
    }

    protected Object decodePrimitive() throws BeanCoderException {
        Class primitiveClass = this.currentClass();
        if (primitiveClass != [B.class) {
            return super.decodePrimitive();
        }
        return this.decodeByteArray();
    }

    protected Object[] decodeMapEntry() throws BeanCoderException {
        if (!this.currentItem.getName().startsWith(this.nsp)) {
            return null;
        }
        if (this.currentItem.getName().equals(this.nsp + PN_CLASS)) {
            return null;
        }
        Object key = null;
        Object value = null;
        if (this.currentItem.isNode()) {
            Node nk = this.currentNode();
            Node nv = nk.getNode(nk.getName());
            key = this.decode();
            this.currentItem = nv;
            value = this.decode();
        } else {
            key = this.currentProperty().getName().substring(this.nsp.length());
            value = this.currentProperty().getValue().getValue();
            if (this.currentProperty().getValue().getType() == 7 && value.equals(V_NULL)) {
                value = null;
            }
        }
        return new Object[]{key, value};
    }

    protected byte[] decodeByteArray() throws BeanCoderException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = this.currentProperty().getValue().getStream();
        try {
            ByteUtils.copy((InputStream)is, (OutputStream)baos, (int)1024);
        }
        catch (Throwable t) {
            throw new BeanCoderException("Failed to decode byte array for '" + this.currentItemName + "' out of stream", t);
        }
        return baos.toByteArray();
    }

    protected void encodeByteArray(byte[] array) throws BeanCoderException {
        this.currentNode().setProperty(this.currentItemName, new ByteArrayInputStream(array));
    }

    public void encode(Object o) throws BeanCoderException {
        if (this.override && !this.overrideDone) {
            Iterator it = this.currentNode().getNodes();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!n.getName().equals(this.currentItemName)) continue;
                n.remove();
            }
            this.overrideDone = true;
        }
        super.encode(o);
    }

    protected void encodeEntry(int index, Object entry) throws BeanCoderException {
        this.currentItemName = this.nsp + index;
        this.encode(entry);
    }

    protected void endElement() throws BeanCoderException {
        this.previousItem = this.currentItem;
        this.currentItem = this.currentItem.getParent();
    }

    protected void encodeNull() throws BeanCoderException {
        this.beginElement();
        this.currentNode().setProperty(this.nsp + PN_CLASS, C_NULL, 7);
    }

    protected void encodePrimitive(Object bean) throws BeanCoderException {
        this.currentNode().setProperty(this.currentItemName, bean.toString(), JcrValueUtils.getJcrType(bean));
    }

    protected void encodeField(String fieldName, Object value) throws BeanCoderException {
        Node beanNode = this.currentNode();
        this.currentItemName = fieldName;
        this.encode(value);
        if (this.currentItem != beanNode) {
            this.previousItem = this.currentItem;
            this.currentItem = beanNode;
        }
    }

    protected void beginBean(Object bean) throws BeanCoderException {
        this.beginWithClass(bean);
        if (BeanCoderUtils.isPrimitive((Object)bean)) {
            this.currentNode().setProperty(this.nsp + PN_PVALUE, bean.toString());
        }
    }

    protected void beginArray(int length) throws BeanCoderException {
        this.beginElement();
        this.currentNode().setProperty(this.nsp + PN_SIZE, "" + length, 3);
    }

    protected void beginWithClass(Object bean) throws BeanCoderException {
        this.beginElement();
        this.currentNode().setProperty(this.nsp + PN_CLASS, bean.getClass().getName());
    }

    protected void beginMap(Map map) throws BeanCoderException {
        this.beginWithClass(map);
    }

    protected boolean isSafeForAnItemName(Object o) {
        return o instanceof String;
    }

    protected Object[] asPropertyMapEntry(Object key, Object val) {
        if (this.isSafeForAnItemName(key) && (val == null || BeanCoderUtils.isPrimitive((Object)val))) {
            return new Object[]{key, val};
        }
        return null;
    }

    protected void encodeMapEntry(Map.Entry e) throws BeanCoderException {
        String keyNodeName;
        Object val;
        Object key = e.getKey();
        Object[] pe = this.asPropertyMapEntry(key, val = e.getValue());
        if (pe != null) {
            key = pe[0];
            val = pe[1];
            int tVal = 7;
            String sVal = V_NULL;
            if (val != null) {
                tVal = JcrValueUtils.getJcrType(val);
                sVal = val.toString();
            }
            this.currentNode().setProperty(key.toString(), sVal, tVal);
            return;
        }
        Node mapNode = this.currentNode();
        this.currentItemName = keyNodeName = this.nsp + NN_ENTRY + "_" + this.getUniqueLocalId();
        this.encodeBean(key);
        this.currentItem = this.previousItem;
        this.currentItemName = keyNodeName;
        this.encode(val);
        this.currentItem = mapNode;
    }

    protected void beginMapEntry() throws BeanCoderException {
    }

    protected void beginCollection(Collection col) throws BeanCoderException {
        this.beginWithClass(col);
    }

    public static void encode(javax.jcr.Node targetNode, String beanNodeName, Object bean) throws BeanCoderException {
        JcrBeanCoder.encode(null, targetNode, beanNodeName, bean);
    }

    public static void encode(String namespace, javax.jcr.Node targetNode, String beanNodeName, Object bean) throws BeanCoderException {
        Node n = (Node)JcrProxy.wrap(targetNode);
        JcrBeanCoder jbc = new JcrBeanCoder(namespace, n, beanNodeName);
        jbc.encode(bean);
    }

    public static Object decode(javax.jcr.Node beanNode) throws BeanCoderException {
        return JcrBeanCoder.decode(null, beanNode);
    }

    public static Object decode(String namespace, javax.jcr.Node beanNode) throws BeanCoderException {
        Node n = (Node)JcrProxy.wrap(beanNode);
        JcrBeanCoder jbc = new JcrBeanCoder(namespace, n);
        return jbc.decode();
    }

    protected class ItemIterator
    implements Iterator {
        private Node node = null;
        private Iterator pit = null;
        private Iterator nit = null;

        public ItemIterator(Node n) throws JcrException {
            this.node = n;
            this.pit = n.getProperties();
            this.nit = n.getNodes();
        }

        public boolean hasNext() {
            if (this.pit.hasNext()) {
                return true;
            }
            return this.nit.hasNext();
        }

        public Object next() {
            Item next = null;
            next = this.pit.hasNext() ? (Item)this.pit.next() : (Item)this.nit.next();
            JcrBeanCoder.this.currentItem = next;
            return null;
        }

        public void remove() {
        }
    }

    protected class IndexedIterator
    implements Iterator {
        private Node node = null;
        private int position = 0;

        public IndexedIterator(Node n) {
            this.node = n;
        }

        public boolean hasNext() {
            String sNext = JcrBeanCoder.this.nsp + this.position;
            try {
                if (this.node.hasProperty(sNext)) {
                    return true;
                }
                if (this.node.hasNode(sNext)) {
                    return true;
                }
            }
            catch (JcrException e) {
                throw new RuntimeException("failed to determine if there's a next item", (Throwable)((Object)e));
            }
            return false;
        }

        public Object next() {
            String sNext = JcrBeanCoder.this.nsp + this.position;
            ++this.position;
            try {
                if (this.node.hasProperty(sNext)) {
                    JcrBeanCoder.this.currentItem = this.node.getProperty(sNext);
                } else {
                    JcrBeanCoder.this.currentItem = this.node.getNode(sNext);
                }
            }
            catch (JcrException e) {
                throw new RuntimeException("failed to reach next item", (Throwable)((Object)e));
            }
            return null;
        }

        public void remove() {
        }
    }
}

