/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.jcr.mock;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import openwfe.org.jcr.Item;
import openwfe.org.jcr.JcrException;
import openwfe.org.jcr.Node;
import openwfe.org.jcr.Property;
import openwfe.org.jcr.mock.MockItem;
import openwfe.org.jcr.mock.MockProperty;
import openwfe.org.jcr.mock.MockValue;

public class MockNode
extends MockItem
implements Node {
    private Map nodes = new LinkedHashMap();
    private Map properties = new LinkedHashMap();

    public MockNode(String name) {
        this(null, name);
    }

    public MockNode(Item parent, String name) {
        super(parent, name);
    }

    public boolean isNode() throws JcrException {
        return true;
    }

    public boolean hasProperty(String propertyName) throws JcrException {
        return this.properties.containsKey(propertyName);
    }

    public Property getProperty(String propertyName) throws JcrException {
        return (Property)this.properties.get(propertyName);
    }

    public Iterator getNodes() {
        return this.nodes.values().iterator();
    }

    public Iterator getProperties() {
        return this.properties.values().iterator();
    }

    public Property setProperty(String propertyName, String value) throws JcrException {
        return this.setProperty(propertyName, value, 1);
    }

    public Property setProperty(String propertyName, String value, int type) throws JcrException {
        MockProperty p = new MockProperty(this, propertyName, new MockValue(value, type));
        this.properties.put(propertyName, p);
        return p;
    }

    public Property setProperty(String propertyName, InputStream value) throws JcrException {
        MockProperty p = new MockProperty(this, propertyName, new MockValue(value));
        this.properties.put(propertyName, p);
        return p;
    }

    public boolean hasNode(String relPath) throws JcrException {
        return this.nodes.containsKey(relPath);
    }

    public Node getNode(String relPath) throws JcrException {
        return (Node)this.nodes.get(relPath);
    }

    public Node addNode(String newNodeName) throws JcrException {
        MockNode n = new MockNode(this, newNodeName);
        this.nodes.put(newNodeName, n);
        return n;
    }

    public void remove() throws JcrException {
        if (this.getParent() != null) {
            ((MockNode)this.getParent()).nodes.remove(this);
        }
    }

    public String render(int depth) throws JcrException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.renderIndent(depth));
        sb.append("n: '").append(this.getName()).append("'");
        sb.append("\n");
        Iterator it = this.properties.values().iterator();
        while (it.hasNext()) {
            sb.append(((MockItem)it.next()).render(depth + 1));
        }
        it = this.nodes.values().iterator();
        while (it.hasNext()) {
            sb.append(((MockItem)it.next()).render(depth + 1));
        }
        return sb.toString();
    }
}

