/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.jcr.mock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import openwfe.org.jcr.JcrException;
import openwfe.org.jcr.Value;
import openwfe.org.misc.Base64;
import openwfe.org.misc.ByteUtils;

public class MockValue
implements Value {
    private int type = 1;
    private Object value = null;

    public MockValue(Object val) {
        this.value = val.toString();
    }

    public MockValue(Object val, int type) {
        this.type = type;
        this.value = val;
    }

    public MockValue(InputStream val) throws JcrException {
        this.type = 2;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteUtils.copy((InputStream)val, (OutputStream)baos, (int)1024);
            this.value = baos.toByteArray();
        }
        catch (IOException ie) {
            throw new JcrException("failed to fetch data from input stream", ie);
        }
    }

    public String getString() throws JcrException {
        try {
            return (String)this.value;
        }
        catch (Throwable t) {
            throw new JcrException("contained value is not a String", t);
        }
    }

    public long getLong() throws JcrException {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        try {
            return Long.parseLong(this.value.toString());
        }
        catch (Throwable t) {
            throw new JcrException("contained value is not a long", t);
        }
    }

    public InputStream getStream() throws JcrException {
        if (!(this.value instanceof byte[])) {
            throw new JcrException("contained value is not returnable as a stream");
        }
        return new ByteArrayInputStream((byte[])this.value);
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() throws JcrException {
        return this.value;
    }

    public Object getWrappedInstance() throws JcrException {
        return null;
    }

    public String toString() {
        if (this.value instanceof byte[]) {
            return new String(Base64.encode((byte[])((byte[])this.value)));
        }
        return this.value.toString();
    }
}

