/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlQueryConfiguration.java 3240 2006-09-08 02:36:09Z jmettraux $
 */

//
// XmlQueryConfiguration.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.query.impl;

import openwfe.org.ServiceException;
import openwfe.org.util.ReflectionUtils;
import openwfe.org.xconf.XconfBuilder;
import openwfe.org.xconf.XconfElementBuilder;
import openwfe.org.query.QueryException;
import openwfe.org.query.QueryConfiguration;
import openwfe.org.query.item.Query;
import openwfe.org.query.item.QueryItem;


/**
 * Mapping which query item implemenation should be used to represent an 'and'
 * or a 'not'...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: XmlQueryConfiguration.java 3240 2006-09-08 02:36:09Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlQueryConfiguration

    implements QueryConfiguration, XconfElementBuilder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlQueryConfiguration.class.getName());

    //
    // CONSTANTS & co

    private final static String E_ITEM = "item";
    private final static String A_NAME = "name";
    private final static String A_CLASS = "class";

    //
    // FIELDS

    private java.util.Map config = null;
    private XconfBuilder builder = null;

    //
    // CONSTRUCTORS

    public XmlQueryConfiguration (final String configUrl)
        throws ServiceException
    {
        this.builder = new XconfBuilder(configUrl, this);
        this.builder.buildConfig();

        log.debug("__init__() for "+configUrl);
    }

    //
    // METHODS from XconfElementBuilder

    /**
     * resets the configuration.
     */
    public void clearConfig ()
    {
        this.config = new java.util.HashMap();
    }

    /**
     * parses a tag element from the configuration
     */
    public void parseElement 
        (final XconfBuilder builder, final org.jdom.Element elt)
    throws 
        ServiceException
    {
        if ( ! elt.getName().equals(E_ITEM)) return;

        final String name = elt.getAttributeValue(A_NAME);
        final String classname = elt.getAttributeValue(A_CLASS);

        this.config.put(name, classname);
    }


    //
    // METHODS

    /**
     * Given a query item in its XML element form, returns the corresponding
     * query item.
     */
    public QueryItem determineQueryItem 
        (final Query parentQuery, final Object o)
    throws
        QueryException
    {
        final org.jdom.Element elt = (org.jdom.Element)o;

        final String classname = (String)this.config.get(elt.getName());

        //log.debug("determineQueryItem() classname : "+classname);

        if (classname == null)
        {
            throw new QueryException
                ("no query item class for elt named '"+elt.getName()+"'");
        }

        final QueryItem qi = 
            (QueryItem)ReflectionUtils.buildNewInstance(classname);
        qi.init(this, parentQuery, elt);

        //if (parentQuery != null) parentQuery.put(qi);

        return qi;
    }

    /**
     * Returns an empty query scope (used at the root of query configs).
     */
    public Query getEmptyQuery ()
        throws QueryException
    {
        final String classname = (String)this.config.get("query");

        if (classname == null)
            throw new QueryException("no query item class for 'query'");

        final Query query = 
            (Query)ReflectionUtils.buildNewInstance(classname);

        return query;
    }

    //
    // STATIC METHODS

}
