/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlQueryMap.java 3104 2006-08-30 13:54:23Z jmettraux $
 */

//
// XmlQueryMap.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.query.impl;

import openwfe.org.FileUtils;
import openwfe.org.MapUtils;
import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.xml.XmlUtils;
import openwfe.org.xconf.XconfBuilder;
import openwfe.org.xconf.XconfElementBuilder;
import openwfe.org.query.QueryMap;
import openwfe.org.query.QueryException;
import openwfe.org.query.item.Query;
import openwfe.org.query.item.QueryItem;


/**
 * An xml query map takes as input two things : a query config
 * and a query map , the query config tells which classes will be used
 * as query items, and the query map tells which queries have been defined.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: XmlQueryMap.java 3104 2006-08-30 13:54:23Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlQueryMap

    extends AbstractService

    implements QueryMap

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlQueryMap.class.getName());

    //
    // CONSTANTS & co

    /**
     * The parameter 'queryConfigurationFile' tells this query map where to
     * find the file telling which classes are mapped behind the tag names
     * in the query maps.
     */
    public final static String P_QUERY_CONFIG
        = "queryConfigurationFile";

    //
    // FIELDS

    private XmlQueryConfiguration config = null;
    private java.util.Map rootQueries = new java.util.HashMap(7);

    //
    // CONSTRUCTORS

    /**
     * Inits this XmlQueryMap.
     */
    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        String queryConfigFileName = 
            MapUtils.getAsString(serviceParams, P_QUERY_CONFIG);

        if (queryConfigFileName == null)
        {
            throw new ServiceException
                ("Mandatory parameter '"+P_QUERY_CONFIG+
                 "' is missing. Cannot init().");
        }

        queryConfigFileName = FileUtils.expandUrl
            (context.getApplicationDirectory(), queryConfigFileName);

        this.config = new XmlQueryConfiguration(queryConfigFileName);
    }

    //
    // METHODS from QueryMap

    public QueryItem lookupQuery (final String queryUrl)
        throws QueryException
    {
        if (log.isDebugEnabled())
            log.debug("lookupQuery() queryUrl >"+queryUrl+"<");

        final String[] url = queryUrl.split("#");
        final String docUrl = url[0];

        Query rootQuery = (Query)this.rootQueries.get(docUrl);

        if (rootQuery != null)
        {
            if (rootQuery.getLastModified() >= 
                FileUtils.getLastModified(docUrl))
                //
                // stored query is up to date, returning it
                //
            {
                return lookupQuery(rootQuery, url, 1);
            }

            log.debug("lookupQuery() reloading  "+docUrl);
        }

        log.debug("lookupQuery() parsing...");

        try
        {
            final org.jdom.Element elt = XmlUtils.extractXml(docUrl, false);

            rootQuery = (Query)getConfig().determineQueryItem(null, elt);

            rootQuery.setLastModified(FileUtils.getLastModified(docUrl));

            this.rootQueries.put(docUrl, rootQuery);
        }
        catch (final Exception e)
        {
            throw new QueryException
                ("Failed to parse "+docUrl, e);
        }

        return lookupQuery(rootQuery, url, 1);
    }

    private static QueryItem lookupQuery 
        (final Query query, final String[] url, final int index)
    throws 
        QueryException
    {
        if (log.isDebugEnabled())
        {
            log.debug("lookupQuery() index is "+index);
            log.debug("lookupQuery() into '"+query.getName()+"'");
            //log.debug("lookupQuery() into\n"+query);
            log.debug("lookupQuery() for '"+url[index]+"'");
        }

        final QueryItem qi = query.get(url[index]);

        if (qi == null)
        {
            log.debug("lookupQuery() found null, returning null");
            return null;
        }

        if (index >= url.length-1) return qi;

        if ( ! (qi instanceof Query))
        {
            throw new QueryException 
                ("Cannot dive into non-scope '"+url[index]+"'");
        }

        //log.debug("lookupQuery() diving into >"+((Query)qi).getName()+"<");

        return lookupQuery((Query)qi, url, index+1);
    }

    //
    // METHODS from Service

    //
    // METHODS

    public XmlQueryConfiguration getConfig ()
    {
        return this.config;
    }

    //
    // STATIC METHODS

}
