/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlAttributeQuery.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// XmlAttributeQuery.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.query.impl.item;

import openwfe.org.query.QueryException;
import openwfe.org.query.QueryConfiguration;
import openwfe.org.query.sets.Set;
import openwfe.org.query.item.Query;
import openwfe.org.query.item.AbstractQueryItem;


/**
 * looking for an element in an XML document
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: XmlAttributeQuery.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlAttributeQuery

    extends XmlNameValueItem

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlAttributeQuery.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from QueryItem

    /**
     * Not implemented here : only the validate method is supported by this
     * class.
     * A call to this method will throw an UnsupportedOperationException.
     */
    public Set query (final Object o)
        throws QueryException
    {
        throw new UnsupportedOperationException
            ("Not implemented here.");
    }

    /**
     * Takes as input a JDOM element and return true if the element or
     * one of its children as an attribute with a matching name and a matching
     * value.
     */
    public boolean validate (final Object o)
        throws QueryException
    {
        final org.jdom.Element elt = (org.jdom.Element)o;

        java.util.Iterator it = elt.getAttributes().iterator();
        while (it.hasNext())
        {
            final org.jdom.Attribute a = (org.jdom.Attribute)it.next();

            if (a.getName().matches(getName()) &&
                a.getValue().matches(getValue())) 
            {
                //log.debug("validate() returning true");
                return true;
            }
        }

        it = elt.getChildren().iterator();
        while (it.hasNext())
            if (validate(it.next())) return true;

        //log.debug("validate() returning false");
        return false;
    }

    //
    // STATIC METHODS

}
