/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlInstanceFieldQueryItem.java 3240 2006-09-08 02:36:09Z jmettraux $
 */

//
// InstanceField.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.query.impl.item;

import openwfe.org.util.ReflectionUtils;
import openwfe.org.query.QueryException;
import openwfe.org.query.QueryConfiguration;
import openwfe.org.query.sets.Set;
import openwfe.org.query.item.Query;
import openwfe.org.query.item.AbstractQueryItem;


/**
 * This query item bases its validation on field names and values of the 
 * java instance passed as argument.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: XmlInstanceFieldQueryItem.java 3240 2006-09-08 02:36:09Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlInstanceFieldQueryItem

    extends XmlNameValueItem

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlInstanceFieldQueryItem.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from QueryItem

    /**
     * Not implemented here : only the validate method is supported by this
     * class.
     * A call to this method will throw an UnsupportedOperationException.
     */
    public Set query (final Object o)
        throws QueryException
    {
        throw new UnsupportedOperationException
            ("Not implemented here.");
    }

    /**
     * Returns true if the Object has a field matching the given name and
     * whose value matches the given value.
     */
    public boolean validate (final Object o)
        throws QueryException
    {
        //log.debug
        //    ("validate() name='"+getName()+"' value='"+getValue()+"'");

        if (o == null) return false;

        final java.util.Iterator it = 
            ReflectionUtils.listAttributes(o).iterator();
        while (it.hasNext())
        {
            final String attributeName = (String)it.next();

            //log.debug
            //    ("validate() considering instance field '"+attributeName+"'");

            if ( ! attributeName.matches(getName())) continue;

            Object value = null;
            try
            {
                value = ReflectionUtils.getAttribute(o, attributeName);
            }
            catch (final Exception e)
            {
                log.debug("validate() reflection problem", e);

                // basically : ignore
            }

            //log.debug
            //    ("validate() attribute value is '"+value+"'");

            if (value == null) continue;

            if (value.toString().matches(getValue())) return true;
        }

        return false;
    }

    //
    // STATIC METHODS

}
