/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Query.java 2291 2006-01-17 20:48:52Z jmettraux $
 */

//
// Query.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.query.item;

import openwfe.org.query.QueryException;
import openwfe.org.query.sets.Set;


/**
 * A query scope may contain other query scopes or simply queries.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: Query.java 2291 2006-01-17 20:48:52Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class Query

    implements QueryItem

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(Query.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private String name = null;
    private Query parentQuery = null;
    private java.util.List items = new java.util.ArrayList(3);

    private String sreference = null;
    private QueryItem reference = null;

    private java.util.Map textSubstitutionMap = null;

    private long lastModified = -1;

    //
    // CONSTRUCTORS

    //
    // METHODS from QueryItem

    /**
     * Does the query and returns a set, the necessary info is given as a java
     * instance.
     * This implementation delegates the work to the underlying [real] query.
     */
    public Set query (final Object o)
        throws QueryException
    {
        final QueryItem qi = fetch();

        return qi.query(o);
    }

    /**
     * Given a [queriable] instance, tells wether this instance satisfies the
     * query.
     * This implementation delegates the work to the underlying [real] query.
     */
    public boolean validate (final Object o)
        throws QueryException
    {
        //log.debug("validate() this is \n"+this.toString());

        final QueryItem qi = fetch();

        //log.debug("validate() fetch returned \n"+qi.toString());

        return qi.validate(o);
    }

    private QueryItem fetch ()
        throws QueryException
    {
        if (getReference() != null) return getReference();

        if (getSreference() != null)
        {
            //log.debug("fetch() looking up "+getSreference());

            final QueryItem qi = lookup(getSreference());

            setReference(qi);

            return qi;
        }

        //
        // no reference ? then uses the first available item

        if (this.items.size() < 1)
        {
            throw new QueryException
                ("Cannot use this Query, "+
                 "it contains no atomic query item");
        }

        //log.debug("'"+getName()+"' fetch() using first available query");

        return (QueryItem)this.items.get(0);
    }

    /**
     * Returns the query to which this query item belongs (or null if this is
     * a top level defined query item).
     */
    public Query getParentQuery ()
    {
        return this.parentQuery;
    }

    public void setParentQuery (final Query q)
    {
        this.parentQuery = q;
    }

    //
    // METHODS

    public String getName ()
    {
        return this.name;
    }

    public void setName (final String s)
    {
        this.name = s;
    }

    public java.util.List getItems ()
    {
        return this.items;
    }

    public QueryItem getReference ()
    {
        return this.reference;
    }

    public void setReference (final QueryItem qi)
    {
        this.reference = qi;
    }

    public String getSreference ()
    {
        return this.sreference;
    }

    public void setSreference (final String s)
    {
        this.sreference = s;
    }

    /**
     * Returns when (long) this queryItem was last modified.
     * Usually this info is up to date only for rootQueries.
     */
    public long getLastModified ()
    {
        return this.lastModified;
    }

    /**
     * This method is called by the XmlQueryMap when it has just build a [this]
     * query.
     */
    public void setLastModified (final long l)
    {
        this.lastModified = l;
    }

    public void put (final QueryItem item)
    {
        this.items.add(item);
    }

    public Query get (final String name)
    {
        //return (Query)this.subQueries.get(name);
        
        final java.util.Iterator it = this.items.iterator();
        while (it.hasNext())
        {
            final QueryItem qi = (QueryItem)it.next();

            if ( ! (qi instanceof Query)) continue;

            final Query q = (Query)qi;

            //if (name.equals(q.getName())) return q;
            if (name.matches(q.getName())) return q;
        }

        return null;
    }

    /**
     * Looks up for a query item in this scope or in the parent scope.
     */
    public Query lookup (final String itemName)
    {
        //log.debug("lookup() in '"+getName()+"' for '"+itemName+"'");

        Query result = this.get(itemName);

        if (result != null) return result;

        //if (getParentQuery() == null) return null;

        return getParentQuery().lookup(itemName);
    }

    /**
     * Returns the value stored in an AssignmentItem ('set', 'property', ...)
     */
    protected String lookupValue (final String name)
    {
        final java.util.Iterator it = this.items.iterator();
        while (it.hasNext())
        {
            final Object o = it.next();
            if ( ! (o instanceof AssignmentItem)) continue;

            final AssignmentItem ai = (AssignmentItem)o;

            if (name.equals(ai.getName())) return ai.getValue();
        }

        if (getParentQuery() != null)
            return getParentQuery().lookupValue(name);
        
        return "";
    }

    /**
     * Returns a view on this query as a Map. This map is intended for use
     * by openwfe.org.misc.Text, when substituting things like ${customer.name}
     */
    public synchronized java.util.Map asTextSubstitutionMap ()
    {
        if (this.textSubstitutionMap == null) 
        {
            this.textSubstitutionMap = (new java.util.AbstractMap ()
                {
                    public Object get (final Object key)
                    {
                        return Query.this.lookupValue(key.toString());
                    }

                    public java.util.Set entrySet ()
                    {
                        return null;
                    }
                });
        }

        return this.textSubstitutionMap;
    }

    public String toString ()
    {
        final StringBuffer sb = new StringBuffer();

        sb.append("<");
        sb.append(this.getClass().getName());
        sb.append("::");
        sb.append(getName());
        sb.append(">\n");

        final java.util.Iterator it = this.items.iterator();
        while (it.hasNext())
        {
            final QueryItem qi = (QueryItem)it.next();

            sb.append(qi.toString());
        }

        sb.append("</");
        sb.append(this.getClass().getName());
        sb.append("::");
        sb.append(getName());
        sb.append(">\n");

        return sb.toString();
    }

    //
    // STATIC METHODS

}
