/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: QueryItem.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// QueryItem.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.query.item;

import openwfe.org.query.QueryException;
import openwfe.org.query.QueryConfiguration;
import openwfe.org.query.sets.Set;


/**
 * The parent of all query items.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: QueryItem.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface QueryItem

    extends java.io.Serializable

{

    /**
     * Inits the query item. 
     * The query configuration is passed, as well as what is necessary to
     * init the item, given as a java instance (object).
     */
    public void init (QueryConfiguration conf, Query parentQuery, Object o)
        throws QueryException;

    /**
     * Returns the query to which this query item belongs (or null if this is
     * a top level defined query item).
     */
    public Query getParentQuery ();

    /**
     * Sets the parent query.
     */
    public void setParentQuery (Query parentQuery);

    /**
     * Does the query and returns a set, the necessary info is given as a java
     * instance.
     */
    public Set query (Object o)
        throws QueryException;

    /**
     * Given a [queriable] instance, tells wether this instance satisfies the
     * query.
     */
    public boolean validate (Object o)
        throws QueryException;

}
