/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractSet.java 3240 2006-09-08 02:36:09Z jmettraux $
 */

//
// AbstractSet.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.query.sets;

import openwfe.org.util.ReflectionUtils;


/**
 * Half an implementation of a Set
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: AbstractSet.java 3240 2006-09-08 02:36:09Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractSet

    implements Set

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractSet.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private boolean negative = false;
    private java.util.Set set = new java.util.HashSet();

    //
    // CONSTRUCTORS

    //
    // METHODS from Set

    /**
     * Returns true if this set is negative (ie an inverted set).
     */
    public boolean isNegative ()
    {
        return this.negative;
    }

    /**
     * Returns true if the st is positive.
     */
    public boolean isPositive ()
    {
        return ! this.negative;
    }

    /**
     * Sets the positive/negative state of the set.
     */
    public void setNegative (final boolean b)
    {
        this.negative = b;
    }

    /**
     * Inverts the state of the set.
     */
    public void invert ()
    {
        this.negative = ( ! this.negative);
    }

    /**
     * Returns a new (and positive) empty instance of this set.
     */
    public Set newInstance ()
    {
        return (Set)ReflectionUtils.newInstance(this);
    }

    //
    // METHODS from java.util.Set

    public int size ()
    {
        return this.set.size();
    }

    public boolean contains (final Object o)
    {
        return this.set.contains(o);
    }

    public Object[] toArray ()
    {
        return this.set.toArray();
    }

    public Object[] toArray (final Object[] array)
    {
        return this.set.toArray(array);
    }
    
    public boolean add (final Object o)
    {
        return this.set.add(o);
    }

    public boolean remove (final Object o)
    {
        return this.set.remove(o);
    }

    public java.util.Iterator iterator ()
    {
        return this.set.iterator();
    }

    public boolean containsAll (final java.util.Collection c)
    {
        return this.set.containsAll(c);
    }

    public boolean addAll (final java.util.Collection c)
    {
        return this.set.addAll(c);
    }

    public boolean retainAll (final java.util.Collection c)
    {
        return this.set.retainAll(c);
    }

    public boolean removeAll (final java.util.Collection c)
    {
        return this.set.removeAll(c);
    }

    public void clear ()
    {
        this.set.clear();
    }

    public boolean isEmpty ()
    {
        return this.set.isEmpty();
    }

    //
    // METHODS

    //
    // ABSTRACT METHODS

    public abstract Object clone ();

    //
    // STATIC METHODS

}
