/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SetUtils.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// SetUtils.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.query.sets;

/**
 * Methods about sets [of results].
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: SetUtils.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class SetUtils
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SetUtils.class.getName());

    //
    // STATIC METHODS

    /**
     * Inverts a set.
     */
    public static Set doNot (final Set s)
    {
        final Set result = (Set)s.clone();
        result.invert();
        return result;
    }

    /**
     * Returns a set that is the union of two sets, ie whose elements
     * belong to either s1 or s2.
     */
    public static Set doUnion (Set s1, Set s2)
    {
        if (s1.isNegative() && s2.isNegative())
            return doNot(doIntersection(doNot(s1), doNot(s2)));

        if (s1.isPositive() && s2.isPositive())
        {
            final Set result = (Set)s1.clone();

            final java.util.Iterator it = s2.iterator();
            while (it.hasNext())
                result.add(it.next());

            return result;
        }

        if (s1.isNegative())
        {
            final Set tmp = s1;
            s1 = s2;
            s2 = tmp;
        }

        final Set result = (Set)s1.clone();

        final java.util.Iterator it = s2.iterator();
        while (it.hasNext())
            result.remove(it.next());

        return result;
    }

    /**
     * Returns a set whose elements belong to both s1 and s2.
     */
    public static Set doIntersection (Set s1, Set s2)
    {
        if (s1.isEmpty() || s2.isEmpty()) return s1.newInstance();
            // shortcut

        if (s1.isNegative() && s2.isNegative())
            return doNot(doUnion(doNot(s1), doNot(s2)));

        if (s1.isPositive() && s2.isPositive())
        {
            final Set result = s1.newInstance();

            final java.util.Iterator it = s1.iterator();
            while (it.hasNext())
            {
                final Object o = it.next();

                if (s2.contains(o))
                    result.add(o);
            }

            return result;
        }

        if (s1.isNegative())
        {
            final Set tmp = s1;
            s1 = (Set)s2.clone();
            s2 = tmp;
        }

        final java.util.Iterator it = s2.iterator();
        while (it.hasNext())
        {
            final Object o = it.next();

            if (s1.contains(o))
                s1.remove(o);
        }

        return s1;
    }

}
