/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.query.impl;

import java.util.HashMap;
import java.util.Map;
import openwfe.org.ServiceException;
import openwfe.org.query.QueryConfiguration;
import openwfe.org.query.QueryException;
import openwfe.org.query.item.Query;
import openwfe.org.query.item.QueryItem;
import openwfe.org.util.ReflectionUtils;
import openwfe.org.xconf.XconfBuilder;
import openwfe.org.xconf.XconfElementBuilder;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XmlQueryConfiguration
implements QueryConfiguration,
XconfElementBuilder {
    private static final Logger log = Logger.getLogger((String)XmlQueryConfiguration.class.getName());
    private static final String E_ITEM = "item";
    private static final String A_NAME = "name";
    private static final String A_CLASS = "class";
    private Map config = null;
    private XconfBuilder builder = null;

    public XmlQueryConfiguration(String configUrl) throws ServiceException {
        this.builder = new XconfBuilder(configUrl, (XconfElementBuilder)this);
        this.builder.buildConfig();
        log.debug((Object)("__init__() for " + configUrl));
    }

    public void clearConfig() {
        this.config = new HashMap();
    }

    public void parseElement(XconfBuilder builder, Element elt) throws ServiceException {
        if (!elt.getName().equals(E_ITEM)) {
            return;
        }
        String name = elt.getAttributeValue(A_NAME);
        String classname = elt.getAttributeValue(A_CLASS);
        this.config.put(name, classname);
    }

    public QueryItem determineQueryItem(Query parentQuery, Object o) throws QueryException {
        Element elt = (Element)o;
        String classname = (String)this.config.get(elt.getName());
        if (classname == null) {
            throw new QueryException("no query item class for elt named '" + elt.getName() + "'");
        }
        QueryItem qi = (QueryItem)ReflectionUtils.buildNewInstance((String)classname);
        qi.init(this, parentQuery, elt);
        return qi;
    }

    public Query getEmptyQuery() throws QueryException {
        String classname = (String)this.config.get("query");
        if (classname == null) {
            throw new QueryException("no query item class for 'query'");
        }
        Query query = (Query)ReflectionUtils.buildNewInstance((String)classname);
        return query;
    }
}

