/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.query.impl;

import java.util.HashMap;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.FileUtils;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.query.QueryException;
import openwfe.org.query.QueryMap;
import openwfe.org.query.impl.XmlQueryConfiguration;
import openwfe.org.query.item.Query;
import openwfe.org.query.item.QueryItem;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XmlQueryMap
extends AbstractService
implements QueryMap {
    private static final Logger log = Logger.getLogger((String)XmlQueryMap.class.getName());
    public static final String P_QUERY_CONFIG = "queryConfigurationFile";
    private XmlQueryConfiguration config = null;
    private Map rootQueries = new HashMap(7);

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        String queryConfigFileName = MapUtils.getAsString((Map)serviceParams, (String)P_QUERY_CONFIG);
        if (queryConfigFileName == null) {
            throw new ServiceException("Mandatory parameter 'queryConfigurationFile' is missing. Cannot init().");
        }
        queryConfigFileName = FileUtils.expandUrl((String)context.getApplicationDirectory(), (String)queryConfigFileName);
        this.config = new XmlQueryConfiguration(queryConfigFileName);
    }

    public QueryItem lookupQuery(String queryUrl) throws QueryException {
        String[] url;
        String docUrl;
        Query rootQuery;
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookupQuery() queryUrl >" + queryUrl + "<"));
        }
        if ((rootQuery = (Query)this.rootQueries.get(docUrl = (url = queryUrl.split("#"))[0])) != null) {
            if (rootQuery.getLastModified() >= FileUtils.getLastModified((String)docUrl)) {
                return XmlQueryMap.lookupQuery(rootQuery, url, 1);
            }
            log.debug((Object)("lookupQuery() reloading  " + docUrl));
        }
        log.debug((Object)"lookupQuery() parsing...");
        try {
            Element elt = XmlUtils.extractXml((String)docUrl, (boolean)false);
            rootQuery = (Query)this.getConfig().determineQueryItem(null, elt);
            rootQuery.setLastModified(FileUtils.getLastModified((String)docUrl));
            this.rootQueries.put(docUrl, rootQuery);
        }
        catch (Exception e) {
            throw new QueryException("Failed to parse " + docUrl, e);
        }
        return XmlQueryMap.lookupQuery(rootQuery, url, 1);
    }

    private static QueryItem lookupQuery(Query query, String[] url, int index) throws QueryException {
        Query qi;
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookupQuery() index is " + index));
            log.debug((Object)("lookupQuery() into '" + query.getName() + "'"));
            log.debug((Object)("lookupQuery() for '" + url[index] + "'"));
        }
        if ((qi = query.get(url[index])) == null) {
            log.debug((Object)"lookupQuery() found null, returning null");
            return null;
        }
        if (index >= url.length - 1) {
            return qi;
        }
        if (!(qi instanceof Query)) {
            throw new QueryException("Cannot dive into non-scope '" + url[index] + "'");
        }
        return XmlQueryMap.lookupQuery(qi, url, index + 1);
    }

    public XmlQueryConfiguration getConfig() {
        return this.config;
    }
}

