/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.query.item;

import java.util.Iterator;
import openwfe.org.query.QueryException;
import openwfe.org.query.item.CompositeQueryItem;
import openwfe.org.query.item.QueryItem;
import openwfe.org.query.sets.Set;
import openwfe.org.query.sets.SetUtils;

public abstract class OrQueryItem
extends CompositeQueryItem {
    public Set query(Object o) throws QueryException {
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            return null;
        }
        Set result = null;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            QueryItem qi = (QueryItem)it.next();
            if (result == null) {
                result = qi.query(o);
                continue;
            }
            result = SetUtils.doUnion(result, qi.query(o));
        }
        return result;
    }

    public boolean validate(Object o) throws QueryException {
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            return false;
        }
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            QueryItem qi = (QueryItem)it.next();
            if (!qi.validate(o)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(this.getClass().getName());
        sb.append("::or>\n");
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            QueryItem qi = (QueryItem)it.next();
            sb.append(qi.toString());
        }
        sb.append("</");
        sb.append(this.getClass().getName());
        sb.append("::or>\n");
        return sb.toString();
    }
}

