/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.query.item;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.query.QueryException;
import openwfe.org.query.item.AssignmentItem;
import openwfe.org.query.item.QueryItem;
import openwfe.org.query.sets.Set;

public abstract class Query
implements QueryItem {
    private String name = null;
    private Query parentQuery = null;
    private List items = new ArrayList(3);
    private String sreference = null;
    private QueryItem reference = null;
    private Map textSubstitutionMap = null;
    private long lastModified = -1L;

    public Set query(Object o) throws QueryException {
        QueryItem qi = this.fetch();
        return qi.query(o);
    }

    public boolean validate(Object o) throws QueryException {
        QueryItem qi = this.fetch();
        return qi.validate(o);
    }

    private QueryItem fetch() throws QueryException {
        if (this.getReference() != null) {
            return this.getReference();
        }
        if (this.getSreference() != null) {
            Query qi = this.lookup(this.getSreference());
            this.setReference(qi);
            return qi;
        }
        if (this.items.size() < 1) {
            throw new QueryException("Cannot use this Query, it contains no atomic query item");
        }
        return (QueryItem)this.items.get(0);
    }

    public Query getParentQuery() {
        return this.parentQuery;
    }

    public void setParentQuery(Query q) {
        this.parentQuery = q;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public List getItems() {
        return this.items;
    }

    public QueryItem getReference() {
        return this.reference;
    }

    public void setReference(QueryItem qi) {
        this.reference = qi;
    }

    public String getSreference() {
        return this.sreference;
    }

    public void setSreference(String s) {
        this.sreference = s;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long l) {
        this.lastModified = l;
    }

    public void put(QueryItem item) {
        this.items.add(item);
    }

    public Query get(String name) {
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            Query q;
            QueryItem qi = (QueryItem)it.next();
            if (!(qi instanceof Query) || !name.matches((q = (Query)qi).getName())) continue;
            return q;
        }
        return null;
    }

    public Query lookup(String itemName) {
        Query result = this.get(itemName);
        if (result != null) {
            return result;
        }
        return this.getParentQuery().lookup(itemName);
    }

    protected String lookupValue(String name) {
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            AssignmentItem ai;
            Object o = it.next();
            if (!(o instanceof AssignmentItem) || !name.equals((ai = (AssignmentItem)o).getName())) continue;
            return ai.getValue();
        }
        if (this.getParentQuery() != null) {
            return this.getParentQuery().lookupValue(name);
        }
        return "";
    }

    public synchronized Map asTextSubstitutionMap() {
        if (this.textSubstitutionMap == null) {
            this.textSubstitutionMap = new AbstractMap(){

                public Object get(Object key) {
                    return Query.this.lookupValue(key.toString());
                }

                public java.util.Set entrySet() {
                    return null;
                }
            };
        }
        return this.textSubstitutionMap;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(this.getClass().getName());
        sb.append("::");
        sb.append(this.getName());
        sb.append(">\n");
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            QueryItem qi = (QueryItem)it.next();
            sb.append(qi.toString());
        }
        sb.append("</");
        sb.append(this.getClass().getName());
        sb.append("::");
        sb.append(this.getName());
        sb.append(">\n");
        return sb.toString();
    }
}

