/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.query.sets;

import java.util.Iterator;
import openwfe.org.query.sets.Set;
import org.apache.log4j.Logger;

public abstract class SetUtils {
    private static final Logger log = Logger.getLogger((String)SetUtils.class.getName());

    public static Set doNot(Set s) {
        Set result = (Set)s.clone();
        result.invert();
        return result;
    }

    public static Set doUnion(Set s1, Set s2) {
        if (s1.isNegative() && s2.isNegative()) {
            return SetUtils.doNot(SetUtils.doIntersection(SetUtils.doNot(s1), SetUtils.doNot(s2)));
        }
        if (s1.isPositive() && s2.isPositive()) {
            Set result = (Set)s1.clone();
            Iterator it = s2.iterator();
            while (it.hasNext()) {
                result.add(it.next());
            }
            return result;
        }
        if (s1.isNegative()) {
            Set tmp = s1;
            s1 = s2;
            s2 = tmp;
        }
        Set result = (Set)s1.clone();
        Iterator it = s2.iterator();
        while (it.hasNext()) {
            result.remove(it.next());
        }
        return result;
    }

    public static Set doIntersection(Set s1, Set s2) {
        if (s1.isEmpty() || s2.isEmpty()) {
            return s1.newInstance();
        }
        if (s1.isNegative() && s2.isNegative()) {
            return SetUtils.doNot(SetUtils.doUnion(SetUtils.doNot(s1), SetUtils.doNot(s2)));
        }
        if (s1.isPositive() && s2.isPositive()) {
            Set result = s1.newInstance();
            Iterator it = s1.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!s2.contains(o)) continue;
                result.add(o);
            }
            return result;
        }
        if (s1.isNegative()) {
            Set tmp = s1;
            s1 = (Set)s2.clone();
            s2 = tmp;
        }
        Iterator it = s2.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!s1.contains(o)) continue;
            s1.remove(o);
        }
        return s1;
    }
}

