/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: HttpContextAttribute.java 3228 2006-09-04 23:48:31Z jmettraux $
 */

//
// HttpContextAttribute.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.webflow;

//import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import openwfe.org.engine.workitem.Attribute;


/**
 * Encapsulating HTTP request and response inside of an OpenWFE attribute
 * (beware : not serializable at all).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: HttpContextAttribute.java 3228 2006-09-04 23:48:31Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class HttpContextAttribute

    implements Attribute

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(HttpContextAttribute.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private HttpServletRequest req = null;
    private HttpServletResponse res = null;

    //
    // CONSTRUCTORS

    public HttpContextAttribute ()
    {
        super();
    }

    public HttpContextAttribute 
        (final HttpServletRequest req, final HttpServletResponse res)
    {
        super();

        this.req = req;
        this.res = res;
    }

    //
    // METHODS from Attribute

    public Object clone ()
    {
        final HttpContextAttribute result = new HttpContextAttribute();

        log.debug("clone()");

        result.req = this.req;
        result.res = this.res;

        return result;
    }

    public boolean equals (final Object o)
    {
        if (o == null) return false;
        if ( ! (o instanceof HttpContextAttribute)) return false;

        final HttpContextAttribute other = (HttpContextAttribute)o;

        return 
            other.req == this.req &&
            other.res == this.res;
    }

    //
    // BEAN METHODS

    public HttpServletRequest getRequest ()
    {
        return this.req;
    }

    public HttpServletResponse getResponse ()
    {
        return this.res;
    }

    public void setRequest (final HttpServletRequest req)
    {
        this.req = req;
    }

    public void setResponse (final HttpServletResponse res)
    {
        this.res = res;
    }

    //
    // METHODS

    public HttpSession getSession ()
    {
        return this.req.getSession();
    }

    //
    // STATIC METHODS

}
