/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WebflowUtils.java 3228 2006-09-04 23:48:31Z jmettraux $
 */

//
// WebflowUtils.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.webflow;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.StringAttribute;


/**
 * Utils methods for the webflow package
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: WebflowUtils.java 3228 2006-09-04 23:48:31Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class WebflowUtils
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(WebflowUtils.class.getName());

    //
    // CONSTANTS & co

    /**
     * The workitem is accessible in the session under the attribute named
     * '__workitem__'.
     */
    public final static String SA_WORKITEM
        = "__workitem__";

    private final static String RA_WORKITEM_ID
        = "__workitem_id__";

    //
    // METHODS

    private static void putWorkitem 
        (final HttpSession session, final InFlowWorkItem wi)
    {
        session.setAttribute(SA_WORKITEM, wi);

        log.debug
            ("putWorkitem() did put "+wi.getLastExpressionId()+
             " into session "+session.getId());
        log.debug
            ("putWorkitem() wi : "+wi);
    }

    /**
     * Puts the workitem in the session and in the request.
     */
    public static void putWorkitem
        (final HttpServletRequest req, final InFlowWorkItem wi)
    {
        final HttpSession session = req.getSession(false);

        putWorkitem(session, wi);

        req.setAttribute(RA_WORKITEM_ID, wi.getLastExpressionId().toString());

        final java.util.Map m = (java.util.Map)AttributeUtils
            .owfe2java(wi.getAttributes());

        final java.util.Iterator it = m.keySet().iterator();
        while (it.hasNext())
        {
            final String key = (String)it.next();

            req.setAttribute(key, m.get(key));
        }
    }

    public static void removeWorkitem (final HttpSession session)
    {
        session.removeAttribute(SA_WORKITEM);
    }

    /**
     * Retrieves the workitem from the HttpSession.
     */
    public static InFlowWorkItem getWorkitem (final HttpSession session)
    {
        final InFlowWorkItem result = 
            (InFlowWorkItem)session.getAttribute(SA_WORKITEM);

        //log.debug
        //    ("getWorkitem() found "+result.getLastExpressionId()+
        //     " in session "+session.getId());

        log.debug
            ("getWorkitem() wi : "+result);

        return result;
    }

    /* *
     * Retrieves the workitem payload from the HttpSession.
     * /
    public static java.util.Map getWiPayload (final HttpSession ses)
    {
        return (java.util.Map)ses.getAttribute(A_WI_PAYLOAD);
    }
     */

    public static InFlowWorkItem recomposeWorkitem 
        (final HttpServletRequest req)
    {
        final HttpSession ses = req.getSession(false);

        if (ses == null) return null;

        final InFlowWorkItem result = getWorkitem(ses);

        if (result == null) return null;

        final java.util.Enumeration en = req.getParameterNames();
        while (en.hasMoreElements())
        {
            final String name = (String)en.nextElement();
            final String[] values = req.getParameterValues(name);

            if (values == null)
            {
                log.debug
                    ("recomposeWorkitem() skipped param '"+name+
                     "'. Null value.");
                continue;
            }

            if (values.length == 1)
                result.getAttributes().puts(name, values[0]);
            else
                result.getAttributes().put(name, toListAttribute(values));
        }

        return result;
    }

    private static ListAttribute toListAttribute (final String[] values)
    {
        final ListAttribute result = new ListAttribute();

        for (int i=0; i<values.length; i++)
            result.add(new StringAttribute(values[i]));

        return result;
    }

    public static void printPlainError 
        (final HttpServletResponse res, final String message)
    throws 
        java.io.IOException
    {
        res.setContentType("text/plain");

        java.io.PrintWriter pw = new java.io.PrintWriter(res.getWriter());

        pw.println("\nerror :\n\n");

        pw.println(message);

        pw.println();

        pw.flush();

        res.flushBuffer();
    }

    public static void printPlainError 
        (final HttpServletResponse res, final Throwable t)
    throws 
        java.io.IOException
    {
        res.setContentType("text/plain");

        java.io.PrintWriter pw = new java.io.PrintWriter(res.getWriter());

        pw.println("\nerror :\n\n");

        t.printStackTrace(pw);

        pw.println();

        pw.flush();

        res.flushBuffer();
    }

}
