/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.webflow;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import openwfe.org.ApplicationContext;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.embed.engine.EmbeddedParticipant;
import openwfe.org.embed.engine.Engine;
import openwfe.org.embed.impl.engine.InMemoryEngine;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.history.TextHistory;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.workitem.CancelItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.misc.WebUtils;
import openwfe.org.webflow.Handler;
import openwfe.org.webflow.HttpContextAttribute;
import openwfe.org.webflow.WebflowUtils;

public class WebflowServlet
extends HttpServlet
implements EmbeddedParticipant {
    public static final String F_HTTP_CONTEXT = "__http_context__";
    public static final String F_HTTP_SESSION_ID = "__http_session_id__";
    public static final String IP_START_PAGE = "startPage";
    public static final String IP_END_PAGE = "endPage";
    public static final String IP_HANDLER_PATH = "handlerPath";
    public static final String IP_FLOW_PATH = "flowPath";
    public static final String IP_HISTORY_PATH = "historyPath";
    public static final String P_WF_ACTION = "wfaction";
    public static final String P_FLOW = "flow";
    public static final String A_START = "start";
    public static final String WFSEQ = "wfseq";
    public static final String DEFAULT_HANDLER_PATH = "WEB-INF/handlers/";
    public static final String DEFAULT_FLOW_PATH = "WEB-INF/flows/";
    private Engine flowEngine = null;
    private Map params = null;
    private URL handlerPath = null;
    private String flowPath = null;

    public WebflowServlet() {
        try {
            this.flowEngine = new InMemoryEngine();
            this.flowEngine.getContext().put("asyncLaunch", (Object)Boolean.FALSE);
            this.flowEngine.registerParticipant((EmbeddedParticipant)this);
        }
        catch (ServiceException e) {
            this.log("build failure", e);
        }
    }

    public void setEngine(Engine e) {
    }

    public void consume(WorkItem wi) throws Exception {
        InFlowWorkItem workitem = (InFlowWorkItem)wi;
        if (workitem.getParticipantName().startsWith("/")) {
            this.forwardToPage(workitem);
        } else {
            this.forwardToHandler(workitem);
        }
    }

    public void cancel(CancelItem ci) {
    }

    protected void forwardToPage(InFlowWorkItem workitem) throws ServletException, IOException {
        this.log("forwardToPage()");
        HttpContextAttribute hca = (HttpContextAttribute)workitem.getAttributes().get((Object)F_HTTP_CONTEXT);
        WebflowUtils.putWorkitem(hca.getRequest(), workitem);
        WebUtils.forward((HttpServletRequest)hca.getRequest(), (HttpServletResponse)hca.getResponse(), (String)workitem.getParticipantName());
    }

    protected void forwardToHandler(InFlowWorkItem workitem) throws Exception {
        this.log("forwardToHandler() loading handler >" + workitem.getParticipantName() + "<");
        Class<?> handlerClass = null;
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{this.handlerPath});
            handlerClass = loader.loadClass(workitem.getParticipantName());
        }
        catch (Throwable t) {
            this.log("forwardToHandler() did not found handler in handlerPath");
        }
        if (handlerClass == null) {
            handlerClass = Class.forName(workitem.getParticipantName());
        }
        Handler handler = (Handler)handlerClass.newInstance();
        HttpContextAttribute hca = (HttpContextAttribute)workitem.getAttributes().get((Object)F_HTTP_CONTEXT);
        boolean shouldReplyToEngine = handler.handle(workitem);
        if (shouldReplyToEngine) {
            this.flowEngine.reply(workitem);
        }
    }

    public void setRegex(String s) {
    }

    public Object dispatch(ApplicationContext context, WorkItem wi) throws DispatchingException {
        if (wi instanceof CancelItem) {
            this.cancel((CancelItem)wi);
            return null;
        }
        try {
            InFlowWorkItem workitem = (InFlowWorkItem)wi;
            this.consume((WorkItem)((InFlowWorkItem)workitem.clone()));
            return null;
        }
        catch (Throwable t) {
            this.log("dispatch() failure", t);
            throw new DispatchingException("dispatch() failure", t);
        }
    }

    public Map getParams() {
        return this.params;
    }

    public String getRegex() {
        return ".*";
    }

    public void init(String regex, Map params) {
        this.params = params;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.flowPath = this.getInitParameter(IP_FLOW_PATH);
        if (this.flowPath == null) {
            this.flowPath = DEFAULT_FLOW_PATH;
        }
        this.log("init() flowPath is " + this.flowPath);
        String s = this.getInitParameter(IP_HANDLER_PATH);
        if (s == null) {
            s = DEFAULT_HANDLER_PATH;
        }
        s = config.getServletContext().getRealPath(s);
        try {
            this.handlerPath = new File(s).toURL();
        }
        catch (MalformedURLException e) {
            throw new ServletException("Failed to determine 'handlerPath' from " + s, (Throwable)e);
        }
        this.log("init() handlerPath : " + this.handlerPath);
        String historyPath = this.getInitParameter(IP_HISTORY_PATH);
        if (historyPath != null) {
            historyPath = config.getServletContext().getRealPath(historyPath);
            HashMap<String, String> hParams = new HashMap<String, String>(1);
            hParams.put("fileName", historyPath);
            TextHistory history = new TextHistory();
            this.log("init() historyPath: " + historyPath);
            try {
                history.init("history", this.flowEngine.getContext(), hParams);
                this.flowEngine.getContext().add((Service)history);
            }
            catch (Exception e) {
                this.log("init() failed to init TextHistory, doing without it.", e);
            }
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String action = req.getParameter(P_WF_ACTION);
        InFlowWorkItem wi = WebflowUtils.recomposeWorkitem(req);
        try {
            if (wi == null) {
                if (A_START.equals(action)) {
                    this.start(req, res);
                    return;
                }
                WebUtils.forward((HttpServletRequest)req, (HttpServletResponse)res, (String)this.getInitParameter(IP_START_PAGE));
                return;
            }
            int reqSeq = WebflowServlet.getSeq(req);
            int sesReq = WebflowServlet.getSeq(req.getSession(false));
            this.log("service() reqSeq : " + reqSeq + "  sesReq : " + sesReq);
            if (reqSeq <= sesReq) {
                this.consume((WorkItem)wi);
                return;
            }
            WebflowServlet.incSeq(req.getSession(false));
            wi.getAttributes().put((Object)F_HTTP_CONTEXT, (Object)new HttpContextAttribute(req, res));
            this.flowEngine.reply(wi);
        }
        catch (Throwable t) {
            this.log("service() error", t);
            WebflowUtils.printPlainError(res, t);
        }
        if (!res.isCommitted()) {
            this.log("service() res is not committed (forwarding to end page)");
            HttpSession session = req.getSession(false);
            if (session != null) {
                WebflowUtils.removeWorkitem(session);
            }
            WebUtils.forward((HttpServletRequest)req, (HttpServletResponse)res, (String)this.getInitParameter(IP_END_PAGE));
        }
    }

    protected void start(HttpServletRequest req, HttpServletResponse res) throws LaunchException {
        HttpSession oldSession = req.getSession(false);
        if (oldSession != null) {
            oldSession.invalidate();
        }
        HttpSession session = req.getSession(true);
        this.log("start() new session is " + session.getId());
        WebflowServlet.incSeq(session);
        String flow = req.getParameter(P_FLOW);
        this.log("start() flow is >" + flow + "<");
        flow = this.getServletContext().getRealPath("/") + "/" + this.flowPath + flow;
        this.log("start() flow is >" + flow + "<");
        LaunchItem li = new LaunchItem();
        li.setWorkflowDefinitionUrl(flow);
        li.getAttributes().put((Object)F_HTTP_CONTEXT, (Object)new HttpContextAttribute(req, res));
        li.getAttributes().puts(F_HTTP_SESSION_ID, session.getId());
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String paramName = (String)en.nextElement();
            String[] values = req.getParameterValues(paramName);
            if (values.length == 1) {
                li.getAttributes().puts(paramName, values[0]);
                continue;
            }
            li.getAttributes().put((Object)paramName, (Object)AttributeUtils.java2owfe((Object)values));
        }
        FlowExpressionId fei = this.flowEngine.launch(li, false);
        this.log("start() flowid is " + fei.getWorkflowInstanceId());
    }

    private static int getSeq(HttpServletRequest req) {
        String s = req.getParameter(WFSEQ);
        if (s == null) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    private static int getSeq(HttpSession session) {
        if (session == null) {
            return -1;
        }
        Integer i = (Integer)session.getAttribute(WFSEQ);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public static int sequence(HttpSession session) {
        int seq = WebflowServlet.getSeq(session);
        if (seq < 0) {
            return seq;
        }
        return seq + 1;
    }

    private static void incSeq(HttpSession session) {
        if (session == null) {
            return;
        }
        int currentSeq = WebflowServlet.getSeq(session);
        session.setAttribute(WFSEQ, (Object)new Integer(currentSeq + 1));
    }

    public static String getActionURL(HttpServletResponse res, HttpSession ses) {
        return res.encodeURL("control?wfseq=" + WebflowServlet.sequence(ses));
    }
}

