/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.webflow;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import org.apache.log4j.Logger;

public abstract class WebflowUtils {
    private static final Logger log = Logger.getLogger((String)WebflowUtils.class.getName());
    public static final String SA_WORKITEM = "__workitem__";
    private static final String RA_WORKITEM_ID = "__workitem_id__";

    private static void putWorkitem(HttpSession session, InFlowWorkItem wi) {
        session.setAttribute(SA_WORKITEM, (Object)wi);
        log.debug((Object)("putWorkitem() did put " + wi.getLastExpressionId() + " into session " + session.getId()));
        log.debug((Object)("putWorkitem() wi : " + wi));
    }

    public static void putWorkitem(HttpServletRequest req, InFlowWorkItem wi) {
        HttpSession session = req.getSession(false);
        WebflowUtils.putWorkitem(session, wi);
        req.setAttribute(RA_WORKITEM_ID, (Object)wi.getLastExpressionId().toString());
        Map m = (Map)AttributeUtils.owfe2java((Attribute)wi.getAttributes());
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            req.setAttribute(key, m.get(key));
        }
    }

    public static void removeWorkitem(HttpSession session) {
        session.removeAttribute(SA_WORKITEM);
    }

    public static InFlowWorkItem getWorkitem(HttpSession session) {
        InFlowWorkItem result = (InFlowWorkItem)session.getAttribute(SA_WORKITEM);
        log.debug((Object)("getWorkitem() wi : " + result));
        return result;
    }

    public static InFlowWorkItem recomposeWorkitem(HttpServletRequest req) {
        HttpSession ses = req.getSession(false);
        if (ses == null) {
            return null;
        }
        InFlowWorkItem result = WebflowUtils.getWorkitem(ses);
        if (result == null) {
            return null;
        }
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String[] values = req.getParameterValues(name);
            if (values == null) {
                log.debug((Object)("recomposeWorkitem() skipped param '" + name + "'. Null value."));
                continue;
            }
            if (values.length == 1) {
                result.getAttributes().puts(name, values[0]);
                continue;
            }
            result.getAttributes().put((Object)name, (Object)WebflowUtils.toListAttribute(values));
        }
        return result;
    }

    private static ListAttribute toListAttribute(String[] values) {
        ListAttribute result = new ListAttribute();
        for (int i = 0; i < values.length; ++i) {
            result.add((Object)new StringAttribute((Object)values[i]));
        }
        return result;
    }

    public static void printPlainError(HttpServletResponse res, String message) throws IOException {
        res.setContentType("text/plain");
        PrintWriter pw = new PrintWriter(res.getWriter());
        pw.println("\nerror :\n\n");
        pw.println(message);
        pw.println();
        pw.flush();
        res.flushBuffer();
    }

    public static void printPlainError(HttpServletResponse res, Throwable t) throws IOException {
        res.setContentType("text/plain");
        PrintWriter pw = new PrintWriter(res.getWriter());
        pw.println("\nerror :\n\n");
        t.printStackTrace(pw);
        pw.println();
        pw.flush();
        res.flushBuffer();
    }
}

