/*
 * Decompiled with CFR 0.152.
 */
package org.openxdm.xcap.client;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.openxdm.xcap.client.key.XcapUriKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallingTask
implements Callable<byte[]> {
    ArrayBlockingQueue<Map<String, Marshaller>> marshallersQueue;
    Object content;
    XcapUriKey key;
    boolean fragment;

    public MarshallingTask(XcapUriKey key, Object content, boolean fragment, ArrayBlockingQueue<Map<String, Marshaller>> marshallersQueue) {
        this.marshallersQueue = marshallersQueue;
        this.content = content;
        this.key = key;
        this.fragment = fragment;
    }

    @Override
    public byte[] call() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        Map<String, Marshaller> marshallers = this.marshallersQueue.take();
        try {
            String keyPackageName = this.content.getClass().getPackage().getName();
            Marshaller marshaller = marshallers.get(keyPackageName);
            if (marshaller == null) {
                JAXBContext context = JAXBContext.newInstance((String)keyPackageName);
                marshaller = context.createMarshaller();
                marshallers.put(keyPackageName, marshaller);
            }
            marshaller.setProperty("jaxb.fragment", (Object)this.fragment);
            marshaller.marshal(this.content, (OutputStream)baos);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.marshallersQueue.put(marshallers);
        }
        return baos.toByteArray();
    }
}

