/*
 * Decompiled with CFR 0.152.
 */
package org.openxdm.xcap.client;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.openxdm.xcap.client.key.XcapUriKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmarshallingTask
implements Callable<Object> {
    ArrayBlockingQueue<Map<String, Unmarshaller>> unmarshallersQueue;
    InputStream in;
    XcapUriKey key;

    public UnmarshallingTask(XcapUriKey key, InputStream in, ArrayBlockingQueue<Map<String, Unmarshaller>> unmarshallersQueue) {
        this.unmarshallersQueue = unmarshallersQueue;
        this.in = in;
        this.key = key;
    }

    @Override
    public Object call() throws Exception {
        Object contentUnmarshalled = null;
        Map<String, Unmarshaller> unmarshallers = this.unmarshallersQueue.take();
        try {
            String keyPackageName = this.key.getClass().getPackage().getName();
            Unmarshaller unmarshaller = unmarshallers.get(keyPackageName);
            if (unmarshaller == null) {
                JAXBContext context = JAXBContext.newInstance((String)keyPackageName);
                unmarshaller = context.createUnmarshaller();
                unmarshallers.put(keyPackageName, unmarshaller);
            }
            contentUnmarshalled = unmarshaller.unmarshal(this.in);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.unmarshallersQueue.put(unmarshallers);
        }
        return contentUnmarshalled;
    }
}

