/*
 * Decompiled with CFR 0.152.
 */
package org.openxdm.xcap.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxdm.xcap.client.MarshallingTask;
import org.openxdm.xcap.client.Response;
import org.openxdm.xcap.client.UnmarshallingTask;
import org.openxdm.xcap.client.XCAPClient;
import org.openxdm.xcap.client.error.XcapError;
import org.openxdm.xcap.client.key.AttributeUriKey;
import org.openxdm.xcap.client.key.DocumentUriKey;
import org.openxdm.xcap.client.key.ElementUriKey;
import org.openxdm.xcap.client.key.NamespaceBindingsUriKey;
import org.openxdm.xcap.client.key.XcapUriKey;

public class XCAPClientImpl
implements XCAPClient {
    private static final Log log = LogFactory.getLog(XCAPClientImpl.class);
    private int SIZE_OF_QUEUES = 10;
    private ArrayBlockingQueue<Map<String, Marshaller>> marshallersQueue;
    private ArrayBlockingQueue<Map<String, Unmarshaller>> unmarshallersQueue;
    private ArrayBlockingQueue<Unmarshaller> errorUnmarshallersQueue;
    private ExecutorService executorService;
    private HttpClient client;
    private String xcapRoot;
    private boolean unmarshallingResponseError = false;

    public XCAPClientImpl(String host, int port, String xcapRoot, int maxConcurrentThreads) throws InterruptedException {
        int i;
        this.xcapRoot = xcapRoot;
        this.SIZE_OF_QUEUES = maxConcurrentThreads;
        this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.client.getHostConfiguration().setHost(host, port, "http");
        this.client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        this.client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        this.marshallersQueue = new ArrayBlockingQueue(this.SIZE_OF_QUEUES);
        for (i = 0; i < this.SIZE_OF_QUEUES; ++i) {
            this.marshallersQueue.put(new HashMap());
        }
        this.unmarshallersQueue = new ArrayBlockingQueue(this.SIZE_OF_QUEUES);
        for (i = 0; i < this.SIZE_OF_QUEUES; ++i) {
            this.unmarshallersQueue.put(new HashMap());
        }
        this.executorService = Executors.newCachedThreadPool();
    }

    public void shutdown() {
        log.info((Object)"shutdown()");
        if (this.client != null) {
            ((MultiThreadedHttpConnectionManager)this.client.getHttpConnectionManager()).shutdown();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.marshallersQueue = null;
        this.unmarshallersQueue = null;
        this.errorUnmarshallersQueue = null;
    }

    public void setUnmarshallingResponseError(boolean value) throws JAXBException {
        log.info((Object)("setUnmarshallingResponseError(value=" + value + ")"));
        if (value) {
            try {
                JAXBContext context = JAXBContext.newInstance((String)XcapError.class.getPackage().getName());
                this.errorUnmarshallersQueue = new ArrayBlockingQueue(this.SIZE_OF_QUEUES);
                for (int i = 0; i < this.SIZE_OF_QUEUES; ++i) {
                    this.errorUnmarshallersQueue.put(context.createUnmarshaller());
                }
            }
            catch (Exception e) {
                this.errorUnmarshallersQueue = null;
                throw new JAXBException((Throwable)e);
            }
        } else {
            this.errorUnmarshallersQueue = null;
        }
        this.unmarshallingResponseError = value;
    }

    public boolean isUnmarshallingResponseError() {
        return this.unmarshallingResponseError;
    }

    private String addXcapRoot(String path) {
        return this.xcapRoot + path;
    }

    private Response getResponse(XcapUriKey key, HttpMethod method, boolean unmarshall) throws JAXBException, IOException {
        try {
            int statusCode = method.getStatusCode();
            Header[] headers = method.getResponseHeaders();
            Object content = null;
            String eTag = null;
            if (statusCode == 200 || statusCode == 201) {
                if (unmarshall) {
                    UnmarshallingTask task = new UnmarshallingTask(key, method.getResponseBodyAsStream(), this.unmarshallersQueue);
                    content = this.executorService.submit(task).get();
                } else {
                    content = method.getResponseBodyAsString();
                }
                Header eTagHeader = method.getResponseHeader("ETag");
                if (eTagHeader != null) {
                    eTag = eTagHeader.getValue();
                }
            } else if (statusCode == 409) {
                if (this.unmarshallingResponseError) {
                    InputStream in = method.getResponseBodyAsStream();
                    if (in != null) {
                        Object errorUnmarshaller = null;
                        this.errorUnmarshallersQueue.take();
                        try {
                            content = errorUnmarshaller.unmarshal(in);
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (JAXBException e) {
                            throw e;
                        }
                        finally {
                            this.errorUnmarshallersQueue.put((Unmarshaller)errorUnmarshaller);
                        }
                    }
                } else {
                    content = method.getResponseBodyAsString();
                }
            }
            Response response = new Response(statusCode, eTag, headers, content, unmarshall);
            log.info((Object)("Received:\n--BEGIN--\n" + response.toString() + "\n--END--"));
            return response;
        }
        catch (InterruptedException ie) {
            throw new JAXBException((Throwable)ie);
        }
        catch (ExecutionException ee) {
            throw new JAXBException((Throwable)ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response get(XcapUriKey key, boolean unmarshall) throws HttpException, IOException, JAXBException {
        Response response = null;
        GetMethod get = new GetMethod(this.addXcapRoot(key.toString()));
        try {
            this.client.executeMethod((HttpMethod)get);
            response = this.getResponse(key, (HttpMethod)get, unmarshall);
        }
        finally {
            get.releaseConnection();
        }
        return response;
    }

    public Response get(XcapUriKey key) throws HttpException, IOException, JAXBException {
        log.info((Object)("get(key=" + key + ")"));
        return this.get(key, false);
    }

    public Response getAndUnmarshallDocument(DocumentUriKey key) throws HttpException, IOException, JAXBException {
        log.info((Object)("getAndUnmarshallDocument(key=" + key + ")"));
        return this.get(key, true);
    }

    public Response getAndUnmarshallElement(ElementUriKey key) throws HttpException, IOException, JAXBException {
        log.info((Object)("getAndUnmarshallElement(key=" + key + ")"));
        return this.get(key, true);
    }

    public Response getAndUnmarshallNamespaceBindings(NamespaceBindingsUriKey key) throws HttpException, IOException, JAXBException {
        log.info((Object)("getAndUnmarshallNamespaceBindings(key=" + key + ")"));
        return this.get(key, true);
    }

    private byte[] marshall(XcapUriKey key, Object content, Boolean fragment) throws JAXBException {
        if (log.isDebugEnabled()) {
            log.info((Object)("marshall(key=" + key + ",fragment=" + fragment + ",content=" + content + ")"));
        }
        MarshallingTask task = new MarshallingTask(key, content, fragment, this.marshallersQueue);
        try {
            return this.executorService.submit(task).get();
        }
        catch (InterruptedException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public Response marshallAndPutDocument(DocumentUriKey key, String mimetype, Object content) throws JAXBException, HttpException, IOException {
        return this.put((XcapUriKey)key, mimetype, this.marshall(key, content, Boolean.FALSE));
    }

    public Response marshallAndPutDocumentIfMatch(DocumentUriKey key, String eTag, String mimetype, Object content) throws JAXBException, HttpException, IOException {
        return this.putIfMatch((XcapUriKey)key, eTag, mimetype, this.marshall(key, content, Boolean.FALSE));
    }

    public Response marshallAndPutDocumentIfNoneMatch(DocumentUriKey key, String eTag, String mimetype, Object content) throws JAXBException, HttpException, IOException {
        return this.putIfNoneMatch((XcapUriKey)key, eTag, mimetype, this.marshall(key, content, Boolean.FALSE));
    }

    public Response marshallAndPutElement(ElementUriKey key, Object content) throws JAXBException, HttpException, IOException {
        return this.put((XcapUriKey)key, "application/xcap-el+xml", this.marshall(key, content, Boolean.TRUE));
    }

    public Response marshallAndPutElementIfMatch(ElementUriKey key, String eTag, Object content) throws JAXBException, HttpException, IOException {
        return this.putIfMatch((XcapUriKey)key, eTag, "application/xcap-el+xml", this.marshall(key, content, Boolean.TRUE));
    }

    public Response marshallAndPutElementIfNoneMatch(ElementUriKey key, String eTag, Object content) throws JAXBException, HttpException, IOException {
        return this.putIfNoneMatch((XcapUriKey)key, eTag, "application/xcap-el+xml", this.marshall(key, content, Boolean.TRUE));
    }

    public Response putDocument(DocumentUriKey key, String mimetype, String content) throws HttpException, IOException, JAXBException {
        return this.put((XcapUriKey)key, mimetype, content);
    }

    public Response putDocumentIfMatch(DocumentUriKey key, String eTag, String mimetype, String content) throws HttpException, IOException, JAXBException {
        return this.putIfMatch((XcapUriKey)key, eTag, mimetype, content);
    }

    public Response putDocumentIfNoneMatch(DocumentUriKey key, String eTag, String mimetype, String content) throws HttpException, IOException, JAXBException {
        return this.putIfNoneMatch((XcapUriKey)key, eTag, mimetype, content);
    }

    public Response putDocument(DocumentUriKey key, String mimetype, byte[] content) throws HttpException, IOException, JAXBException {
        return this.put((XcapUriKey)key, mimetype, content);
    }

    public Response putDocumentIfMatch(DocumentUriKey key, String eTag, String mimetype, byte[] content) throws HttpException, IOException, JAXBException {
        return this.putIfMatch((XcapUriKey)key, eTag, mimetype, content);
    }

    public Response putDocumentIfNoneMatch(DocumentUriKey key, String eTag, String mimetype, byte[] content) throws HttpException, IOException, JAXBException {
        return this.putIfNoneMatch((XcapUriKey)key, eTag, mimetype, content);
    }

    public Response putElement(ElementUriKey key, String content) throws HttpException, IOException, JAXBException {
        return this.put((XcapUriKey)key, "application/xcap-el+xml", content);
    }

    public Response putElementIfMatch(ElementUriKey key, String eTag, String content) throws HttpException, IOException, JAXBException {
        return this.putIfMatch((XcapUriKey)key, eTag, "application/xcap-el+xml", content);
    }

    public Response putElementIfNoneMatch(ElementUriKey key, String eTag, String content) throws HttpException, IOException, JAXBException {
        return this.putIfNoneMatch((XcapUriKey)key, eTag, "application/xcap-el+xml", content);
    }

    public Response putElement(ElementUriKey key, byte[] content) throws HttpException, IOException, JAXBException {
        return this.put((XcapUriKey)key, "application/xcap-el+xml", content);
    }

    public Response putElementIfMatch(ElementUriKey key, String eTag, byte[] content) throws HttpException, IOException, JAXBException {
        return this.putIfMatch((XcapUriKey)key, eTag, "application/xcap-el+xml", content);
    }

    public Response putElementIfNoneMatch(ElementUriKey key, String eTag, byte[] content) throws HttpException, IOException, JAXBException {
        return this.putIfNoneMatch((XcapUriKey)key, eTag, "application/xcap-el+xml", content);
    }

    public Response putAttribute(AttributeUriKey key, String content) throws HttpException, IOException, JAXBException {
        return this.put((XcapUriKey)key, "application/xcap-att+xml", content);
    }

    public Response putAttributeIfMatch(AttributeUriKey key, String eTag, String content) throws HttpException, IOException, JAXBException {
        return this.putIfMatch((XcapUriKey)key, eTag, "application/xcap-att+xml", content);
    }

    public Response putAttributeIfNoneMatch(AttributeUriKey key, String eTag, String content) throws HttpException, IOException, JAXBException {
        return this.putIfNoneMatch((XcapUriKey)key, eTag, "application/xcap-att+xml", content);
    }

    public Response putAttribute(AttributeUriKey key, byte[] content) throws HttpException, IOException, JAXBException {
        return this.put((XcapUriKey)key, "application/xcap-att+xml", content);
    }

    public Response putAttributeIfMatch(AttributeUriKey key, String eTag, byte[] content) throws HttpException, IOException, JAXBException {
        return this.putIfMatch((XcapUriKey)key, eTag, "application/xcap-att+xml", content);
    }

    public Response putAttributeIfNoneMatch(AttributeUriKey key, String eTag, byte[] content) throws HttpException, IOException, JAXBException {
        return this.putIfNoneMatch((XcapUriKey)key, eTag, "application/xcap-att+xml", content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response put(XcapUriKey key, String mimetype, String content) throws HttpException, IOException, JAXBException {
        log.info((Object)("put(key=" + key + ", mimetype=" + mimetype + ", content=" + content + ")"));
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestEntity((RequestEntity)new StringRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put, false);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response putIfMatch(XcapUriKey key, String eTag, String mimetype, String content) throws HttpException, IOException, JAXBException {
        log.info((Object)("putIfMatch(key=" + key + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + ")"));
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestHeader("If-Match", eTag);
        put.setRequestEntity((RequestEntity)new StringRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put, false);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response putIfNoneMatch(XcapUriKey key, String eTag, String mimetype, String content) throws HttpException, IOException, JAXBException {
        log.info((Object)("putIfNoneMatch(key=" + key + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + ")"));
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestHeader("If-None-Match", eTag);
        put.setRequestEntity((RequestEntity)new StringRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put, false);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response put(XcapUriKey key, String mimetype, byte[] content) throws HttpException, IOException, JAXBException {
        log.info((Object)("put(key=" + key + ", mimetype=" + mimetype + ", content=" + content + ")"));
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put, false);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response putIfMatch(XcapUriKey key, String eTag, String mimetype, byte[] content) throws HttpException, IOException, JAXBException {
        log.info((Object)("putIfMatch(key=" + key + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + ")"));
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestHeader("If-Match", eTag);
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put, false);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response putIfNoneMatch(XcapUriKey key, String eTag, String mimetype, byte[] content) throws HttpException, IOException, JAXBException {
        log.info((Object)("putIfNoneMatch(key=" + key + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + ")"));
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestHeader("If-None-Match", eTag);
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put, false);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response delete(XcapUriKey key) throws HttpException, IOException, JAXBException {
        log.info((Object)("delete(key=" + key + ")"));
        Response response = null;
        DeleteMethod delete = new DeleteMethod(this.addXcapRoot(key.toString()));
        try {
            this.client.executeMethod((HttpMethod)delete);
            response = this.getResponse(key, (HttpMethod)delete, false);
        }
        finally {
            delete.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response deleteIfMatch(XcapUriKey key, String eTag) throws HttpException, IOException, JAXBException {
        log.info((Object)("deleteIfMatch(key=" + key + ", eTag=" + eTag + ")"));
        Response response = null;
        DeleteMethod delete = new DeleteMethod(this.addXcapRoot(key.toString()));
        try {
            delete.setRequestHeader("If-Match", eTag);
            this.client.executeMethod((HttpMethod)delete);
            response = this.getResponse(key, (HttpMethod)delete, false);
        }
        finally {
            delete.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response deleteIfNoneMatch(XcapUriKey key, String eTag) throws HttpException, IOException, JAXBException {
        log.info((Object)("deleteIfNoneMatch(key=" + key + ", eTag=" + eTag + ")"));
        Response response = null;
        DeleteMethod delete = new DeleteMethod(this.addXcapRoot(key.toString()));
        try {
            delete.setRequestHeader("If-None-Match", eTag);
            this.client.executeMethod((HttpMethod)delete);
            response = this.getResponse(key, (HttpMethod)delete, false);
        }
        finally {
            delete.releaseConnection();
        }
        return response;
    }

    public Response deleteDocument(DocumentUriKey key) throws HttpException, IOException, JAXBException {
        return this.delete(key);
    }

    public Response deleteDocumentIfMatch(DocumentUriKey key, String eTag) throws HttpException, IOException, JAXBException {
        return this.deleteIfMatch(key, eTag);
    }

    public Response deleteDocumentIfNoneMatch(DocumentUriKey key, String eTag) throws HttpException, IOException, JAXBException {
        return this.deleteIfNoneMatch(key, eTag);
    }

    public Response deleteElement(ElementUriKey key) throws HttpException, IOException, JAXBException {
        return this.delete(key);
    }

    public Response deleteElementIfMatch(ElementUriKey key, String eTag) throws HttpException, IOException, JAXBException {
        return this.deleteIfMatch(key, eTag);
    }

    public Response deleteElementIfNoneMatch(ElementUriKey key, String eTag) throws HttpException, IOException, JAXBException {
        return this.deleteIfNoneMatch(key, eTag);
    }

    public Response deleteAttribute(AttributeUriKey key) throws HttpException, IOException, JAXBException {
        return this.delete(key);
    }

    public Response deleteAttributeIfMatch(AttributeUriKey key, String eTag) throws HttpException, IOException, JAXBException {
        return this.deleteIfMatch(key, eTag);
    }

    public Response deleteAttributeIfNoneMatch(AttributeUriKey key, String eTag) throws HttpException, IOException, JAXBException {
        return this.deleteIfNoneMatch(key, eTag);
    }
}

