/*
 * Decompiled with CFR 0.152.
 */
package org.openxdm.xcap.client.key;

import java.util.Map;
import org.openxdm.xcap.client.key.KeyUtils;
import org.openxdm.xcap.client.key.XcapUriKey;
import org.openxdm.xcap.common.uri.AttributeSelector;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.openxdm.xcap.common.uri.ElementSelector;
import org.openxdm.xcap.common.uri.ResourceSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeUriKey
extends XcapUriKey {
    private static final long serialVersionUID = 1L;
    private DocumentSelector documentSelector;
    private ElementSelector elementSelector;
    private AttributeSelector attributeSelector;
    private Map<String, String> namespaces;

    public AttributeUriKey(DocumentSelector documentSelector, ElementSelector elementSelector, AttributeSelector attributeSelector, Map<String, String> namespaces) {
        super(new ResourceSelector(documentSelector.toString(), AttributeUriKey.getNodeSelector(elementSelector, attributeSelector), namespaces));
        this.documentSelector = documentSelector;
        this.elementSelector = elementSelector;
        this.namespaces = namespaces;
    }

    private static String getNodeSelector(ElementSelector elementSelector, AttributeSelector attributeSelector) {
        return KeyUtils.getPercentEncondedElementSelector(elementSelector) + '/' + KeyUtils.getPercentEncodedString(attributeSelector.toString());
    }

    public AttributeSelector getAttributeSelector() {
        return this.attributeSelector;
    }

    public DocumentSelector getDocumentSelector() {
        return this.documentSelector;
    }

    public ElementSelector getElementSelector() {
        return this.elementSelector;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }
}

