/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xri3.impl;

import java.util.ArrayList;
import java.util.List;
import org.openxri.xri3.XRIPath;
import org.openxri.xri3.XRISegment;
import org.openxri.xri3.impl.XRI3Segment;
import org.openxri.xri3.impl.XRI3SyntaxComponent;
import org.openxri.xri3.impl.XRI3Util;
import org.openxri.xri3.impl.parser.Parser;
import org.openxri.xri3.impl.parser.ParserException;
import org.openxri.xri3.impl.parser.Rule;

public class XRI3Path
extends XRI3SyntaxComponent
implements XRIPath {
    private static final long serialVersionUID = 482492757184837341L;
    private Rule rule;
    private List segments;

    public XRI3Path(String string) throws ParserException {
        this.rule = XRI3Util.getParser().parse("xri-path", string);
        this.read();
    }

    XRI3Path(Rule rule) {
        this.rule = rule;
        this.read();
    }

    private void reset() {
        this.segments = new ArrayList();
    }

    private void read() {
        this.reset();
        Rule object = this.rule;
        if (object instanceof Parser.xri_path) {
            ArrayList list_xri_path = ((Parser.xri_path)object).rules;
            if (list_xri_path.size() < 1) {
                return;
            }
            object = list_xri_path.get(0);
        }
        if (object instanceof Parser.xri_path_abempty) {
            ArrayList list_xri_path_abempty = ((Parser.xri_path_abempty)object).rules;
            if (list_xri_path_abempty.size() < 2) {
                return;
            }
            int i = 0;
            while (i + 1 < list_xri_path_abempty.size()) {
                object = list_xri_path_abempty.get(i + 1);
                this.segments.add(new XRI3Segment((Parser.xri_segment)object));
                i += 2;
            }
        } else if (object instanceof Parser.xri_path_abs) {
            ArrayList list_xri_path_abs = ((Parser.xri_path_abs)object).rules;
            if (list_xri_path_abs.size() < 2) {
                return;
            }
            object = list_xri_path_abs.get(1);
            this.segments.add(new XRI3Segment((Parser.xri_segment_nz)object));
            if (list_xri_path_abs.size() < 4) {
                return;
            }
            int i = 2;
            while (i + 1 < list_xri_path_abs.size()) {
                object = list_xri_path_abs.get(i + 1);
                this.segments.add(new XRI3Segment((Parser.xri_segment)object));
                i += 2;
            }
        } else if (object instanceof Parser.xri_path_noscheme) {
            ArrayList list_xri_path_noscheme = ((Parser.xri_path_noscheme)object).rules;
            if (list_xri_path_noscheme.size() < 1) {
                return;
            }
            object = list_xri_path_noscheme.get(0);
            this.segments.add(new XRI3Segment((Parser.xri_segment_nc)object));
            if (list_xri_path_noscheme.size() < 3) {
                return;
            }
            int i = 1;
            while (i + 1 < list_xri_path_noscheme.size()) {
                object = list_xri_path_noscheme.get(i + 1);
                this.segments.add(new XRI3Segment((Parser.xri_segment)object));
                i += 2;
            }
        } else {
            throw new ClassCastException(object.getClass().getName());
        }
    }

    public Rule getParserObject() {
        return this.rule;
    }

    public List getSegments() {
        return this.segments;
    }

    public int getNumSegments() {
        return this.segments.size();
    }

    public XRISegment getSegment(int i) {
        return (XRISegment)this.segments.get(i);
    }

    public XRISegment getFirstSegment() {
        if (this.segments.size() < 1) {
            return null;
        }
        return (XRISegment)this.segments.get(0);
    }

    public XRISegment getLastSegment() {
        if (this.segments.size() < 1) {
            return null;
        }
        return (XRISegment)this.segments.get(this.segments.size() - 1);
    }

    public boolean startsWith(XRISegment[] segments) {
        if (this.segments.size() < segments.length) {
            return false;
        }
        for (int i = 0; i < segments.length; ++i) {
            if (this.segments.get(i).equals(segments[i])) continue;
            return false;
        }
        return true;
    }
}

