/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.config.impl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openxri.config.ComponentRegistry;
import org.openxri.config.PipelineRegistry;
import org.openxri.config.ServerConfig;
import org.openxri.config.impl.XMLComponentRegistry;
import org.openxri.config.impl.XMLPipelineRegistry;
import org.openxri.exceptions.ConfigException;
import org.openxri.exceptions.ConfigParseException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLServerConfig
extends DefaultHandler
implements ServerConfig {
    public static final String SERVER_CONFIG_FILE = "server.config.file";
    public static final String DEFAULT_SERVER_CONFIG_FILE = "/WEB-INF/server.xml";
    public static final String NAMESPACE = "http://www.openxri.org/namespaces/serverconfig";
    public static final String ELEMENT_CLASS = "class";
    public static final String ELEMENT_PROPERTIES = "properties";
    public static final String ELEMENT_PROPERTY = "property";
    public static final String ELEMENT_COMPONENT = "component";
    public static final String ELEMENT_PIPELINE = "pipeline";
    public static final String ELEMENT_STAGE = "stage";
    public static final String ATTR_PROPERTY_KEY = "key";
    public static final String ATTR_PROPERTY_VALUE = "value";
    public static final String ATTR_COMPONENT_INTERFACE = "interface";
    public static final String ATTR_PIPELINE_NAME = "name";
    public static final String PIPELINE_DEFAULT_NAME = null;
    public static final String PROPERTIES_KEY_HOSTNAME = "hostname";
    public static final String PROPERTIES_KEY_HOSTPORT = "hostport";
    public static final String PROPERTIES_KEY_SERVLETPATH = "servletpath";
    private String filename;
    private Properties properties = null;
    private XMLComponentRegistry componentRegistry;
    private XMLPipelineRegistry pipelineRegistry;
    private List<ComponentConfig> componentConfigs = new ArrayList<ComponentConfig>();
    private List<PipelineConfig> pipelineConfigs = new ArrayList<PipelineConfig>();
    private Delegate delegate;
    private SAXParseException ex;

    public XMLServerConfig(ServletContext servletContext, Properties properties) {
        this.filename = properties.getProperty(SERVER_CONFIG_FILE, DEFAULT_SERVER_CONFIG_FILE);
        if (servletContext != null) {
            this.filename = servletContext.getRealPath(this.filename);
        }
    }

    public void init() throws IOException, ConfigException {
        File file = new File(this.filename);
        InputSource source = file.exists() ? new InputSource(new FileReader(file)) : new InputSource(this.getClass().getResourceAsStream(this.filename));
        this.parse(source);
        this.componentRegistry = new XMLComponentRegistry(this.componentConfigs);
        this.pipelineRegistry = new XMLPipelineRegistry(this.pipelineConfigs);
        this.componentRegistry.init();
        this.pipelineRegistry.init();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public PipelineRegistry getPipelineRegistry() {
        return this.pipelineRegistry;
    }

    public String getHostName() {
        return this.properties.getProperty(PROPERTIES_KEY_HOSTNAME);
    }

    public String getHostPort() {
        return this.properties.getProperty(PROPERTIES_KEY_HOSTPORT);
    }

    public String getServletPath() {
        return this.properties.getProperty(PROPERTIES_KEY_SERVLETPATH);
    }

    protected void parse(InputSource input) throws IOException, ConfigException {
        SAXParser parser;
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        try {
            parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new ConfigParseException(0, "Cannot configure XML parser.", ex);
        }
        catch (SAXException ex) {
            throw new ConfigParseException(0, "Cannot create XML parser.", ex);
        }
        try {
            parser.parse(input, (DefaultHandler)this);
        }
        catch (SAXException ex2) {
            SAXParseException ex2;
            int line = 0;
            if (this.ex != null) {
                line = ((SAXParseException)ex2).getLineNumber();
                ex2 = this.ex;
            }
            throw new ConfigParseException(line, "Error parsing XML graph: " + ex2.getMessage(), ex2);
        }
    }

    public void startDocument() throws SAXException {
        this.delegate = null;
    }

    public void endDocument() throws SAXException {
        this.delegate = null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.delegate != null) {
            this.delegate.characters(ch, start, length);
            return;
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.delegate != null) {
            this.delegate.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (!NAMESPACE.equals(namespaceURI)) {
            return;
        }
        if (ELEMENT_PROPERTIES.equals(localName)) {
            this.delegate = new PropertiesConfig(namespaceURI, localName, qName, atts);
            return;
        }
        if (ELEMENT_COMPONENT.equals(localName)) {
            this.delegate = new ComponentConfig(namespaceURI, localName, qName, atts);
            return;
        }
        if (ELEMENT_PIPELINE.equals(localName)) {
            this.delegate = new PipelineConfig(namespaceURI, localName, qName, atts);
            return;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.delegate != null && this.delegate.delegate != null) {
            this.delegate.endElement(namespaceURI, localName, qName);
            return;
        }
        if (!NAMESPACE.equals(namespaceURI)) {
            return;
        }
        if (ELEMENT_PROPERTIES.equals(localName)) {
            this.properties = ((PropertiesConfig)this.delegate).getProperties();
            this.delegate = null;
            return;
        }
        if (ELEMENT_COMPONENT.equals(localName)) {
            if (((ComponentConfig)this.delegate).getInterfaceName() == null) {
                return;
            }
            this.componentConfigs.add((ComponentConfig)this.delegate);
            this.delegate = null;
            return;
        }
        if (ELEMENT_PIPELINE.equals(localName)) {
            if (((PipelineConfig)this.delegate).getName() == null) {
                return;
            }
            this.pipelineConfigs.add((PipelineConfig)this.delegate);
            this.delegate = null;
            return;
        }
    }

    public void error(SAXParseException ex) throws SAXException {
        this.ex = ex;
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.ex = ex;
    }

    public void warning(SAXParseException ex) throws SAXException {
        this.ex = ex;
    }

    static class PropertiesConfig
    extends Delegate {
        private Properties properties = new Properties();

        protected PropertiesConfig(String namespaceURI, String localName, String qName, Attributes atts) {
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(ch, start, length);
                return;
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (!XMLServerConfig.NAMESPACE.equals(namespaceURI)) {
                return;
            }
            if (XMLServerConfig.ELEMENT_PROPERTY.equals(localName)) {
                String key = atts.getValue(XMLServerConfig.ATTR_PROPERTY_KEY);
                String value = atts.getValue(XMLServerConfig.ATTR_PROPERTY_VALUE);
                if (key == null) {
                    return;
                }
                this.properties.setProperty(key, value);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.delegate != null && this.delegate.delegate != null) {
                this.delegate.endElement(namespaceURI, localName, qName);
                return;
            }
            if (!XMLServerConfig.NAMESPACE.equals(namespaceURI)) {
                return;
            }
        }
    }

    static class StageConfig
    extends Delegate {
        private String className;
        private Properties properties;

        protected StageConfig(String namespaceURI, String localName, String qName, Attributes atts) {
        }

        public String getClassName() {
            return this.className;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(ch, start, length);
                return;
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.delegate != null) {
                this.delegate.startElement(namespaceURI, localName, qName, atts);
                return;
            }
            if (!XMLServerConfig.NAMESPACE.equals(namespaceURI)) {
                return;
            }
            if (XMLServerConfig.ELEMENT_CLASS.equals(localName)) {
                this.delegate = new StringConfig(namespaceURI, localName, qName, atts);
                return;
            }
            if (XMLServerConfig.ELEMENT_PROPERTIES.equals(localName)) {
                this.delegate = new PropertiesConfig(namespaceURI, localName, qName, atts);
                return;
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.delegate != null && this.delegate.delegate != null) {
                this.delegate.endElement(namespaceURI, localName, qName);
                return;
            }
            if (!XMLServerConfig.NAMESPACE.equals(namespaceURI)) {
                return;
            }
            if (XMLServerConfig.ELEMENT_CLASS.equals(localName)) {
                this.className = ((StringConfig)this.delegate).getString();
                this.delegate = null;
                return;
            }
            if (XMLServerConfig.ELEMENT_PROPERTIES.equals(localName)) {
                this.properties = ((PropertiesConfig)this.delegate).getProperties();
                this.delegate = null;
                return;
            }
        }
    }

    static class StringConfig
    extends Delegate {
        private String string = "";

        protected StringConfig(String namespaceURI, String localName, String qName, Attributes atts) {
        }

        public String getString() {
            return this.string;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            char[] slice = new char[length];
            System.arraycopy(ch, start, slice, 0, length);
            String str = new String(slice);
            this.string = this.string + str;
        }
    }

    static class ComponentConfig
    extends Delegate {
        private String interfaceName;
        private String className;
        private Properties properties;

        protected ComponentConfig(String namespaceURI, String localName, String qName, Attributes atts) {
            this.interfaceName = atts.getValue(XMLServerConfig.ATTR_COMPONENT_INTERFACE);
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public String getClassName() {
            return this.className;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(ch, start, length);
                return;
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.delegate != null) {
                this.delegate.startElement(namespaceURI, localName, qName, atts);
                return;
            }
            if (!XMLServerConfig.NAMESPACE.equals(namespaceURI)) {
                return;
            }
            if (XMLServerConfig.ELEMENT_CLASS.equals(localName)) {
                this.delegate = new StringConfig(namespaceURI, localName, qName, atts);
                return;
            }
            if (XMLServerConfig.ELEMENT_PROPERTIES.equals(localName)) {
                this.delegate = new PropertiesConfig(namespaceURI, localName, qName, atts);
                return;
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.delegate != null && this.delegate.delegate != null) {
                this.delegate.endElement(namespaceURI, localName, qName);
                return;
            }
            if (!XMLServerConfig.NAMESPACE.equals(namespaceURI)) {
                return;
            }
            if (XMLServerConfig.ELEMENT_CLASS.equals(localName)) {
                this.className = ((StringConfig)this.delegate).getString();
                this.delegate = null;
                return;
            }
            if (XMLServerConfig.ELEMENT_PROPERTIES.equals(localName)) {
                this.properties = ((PropertiesConfig)this.delegate).getProperties();
                this.delegate = null;
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PipelineConfig
    extends Delegate {
        private String name;
        private List<StageConfig> stages;

        protected PipelineConfig(String namespaceURI, String localName, String qName, Attributes atts) {
            try {
                this.name = atts.getValue(XMLServerConfig.ATTR_PIPELINE_NAME);
            }
            catch (Exception ex) {
                this.name = PIPELINE_DEFAULT_NAME;
            }
            this.stages = new ArrayList<StageConfig>();
        }

        public String getName() {
            return this.name;
        }

        public List<StageConfig> getStageConfigs() {
            return this.stages;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(ch, start, length);
                return;
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.delegate != null) {
                this.delegate.startElement(namespaceURI, localName, qName, atts);
                return;
            }
            if (!XMLServerConfig.NAMESPACE.equals(namespaceURI)) {
                return;
            }
            if (XMLServerConfig.ELEMENT_STAGE.equals(localName)) {
                this.delegate = new StageConfig(namespaceURI, localName, qName, atts);
                return;
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.delegate != null && this.delegate.delegate != null) {
                this.delegate.endElement(namespaceURI, localName, qName);
                return;
            }
            if (!XMLServerConfig.NAMESPACE.equals(namespaceURI)) {
                return;
            }
            if (XMLServerConfig.ELEMENT_STAGE.equals(localName)) {
                this.stages.add((StageConfig)this.delegate);
                this.delegate = null;
                return;
            }
        }
    }

    static abstract class Delegate
    extends DefaultHandler {
        protected Delegate delegate;

        Delegate() {
        }
    }
}

