/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.factories;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.config.ServerConfig;
import org.openxri.config.impl.XMLServerConfig;

public class ServerConfigFactory {
    private static Log log = LogFactory.getLog((String)ServerConfigFactory.class.getName());
    public static final String SERVER_CONFIG_CLASS = "server.config.class";
    public static final String DEFAULT_SERVER_CONFIG_CLASS = XMLServerConfig.class.getName();
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static ServerConfig instance = null;

    private ServerConfigFactory() {
    }

    public static synchronized ServerConfig initSingleton(ServletContext servletContext, Properties properties) throws Exception {
        String className = properties.getProperty(SERVER_CONFIG_CLASS);
        if (className == null) {
            className = DEFAULT_SERVER_CONFIG_CLASS;
        }
        log.info((Object)("Using ServerConfig implementation class: " + className + "."));
        Class<?> clazz = classLoader.loadClass(className);
        Constructor<?> constructor = clazz.getConstructor(ServletContext.class, Properties.class);
        instance = (ServerConfig)constructor.newInstance(servletContext, properties);
        instance.init();
        log.debug((Object)("Successfully constructed ServerConfig implementation: " + className));
        return instance;
    }

    public static synchronized ServerConfig initSingleton(ServletConfig servletConfig) throws Exception {
        Properties properties = new Properties();
        Enumeration e = servletConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String initParameterName = (String)e.nextElement();
            properties.setProperty(initParameterName, servletConfig.getInitParameter(initParameterName));
        }
        return ServerConfigFactory.initSingleton(servletConfig.getServletContext(), properties);
    }

    public static synchronized ServerConfig initSingleton(FilterConfig filterConfig) throws Exception {
        Properties properties = new Properties();
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String initParameterName = (String)e.nextElement();
            properties.setProperty(initParameterName, filterConfig.getInitParameter(initParameterName));
        }
        return ServerConfigFactory.initSingleton(filterConfig.getServletContext(), properties);
    }

    public static synchronized ServerConfig getSingleton() {
        return instance;
    }

    public static synchronized ClassLoader getClassLoader() {
        return classLoader;
    }

    public static synchronized void setClassLoader(ClassLoader classLoader) {
        ServerConfigFactory.classLoader = classLoader;
    }
}

