/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.pipeline.stages;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Vector;
import org.openxri.XRISegment;
import org.openxri.config.ServerConfig;
import org.openxri.exceptions.StageException;
import org.openxri.exceptions.StoreException;
import org.openxri.factories.ServerConfigFactory;
import org.openxri.pipeline.stages.AbstractStage;
import org.openxri.resolve.TrustType;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreBetterLookup;
import org.openxri.store.SubSegment;
import org.openxri.urimapper.URIMapper;
import org.openxri.xml.AuthorityResolutionService;
import org.openxri.xml.CanonicalID;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;

public class AddAuthorityResolutionSEPStage
extends AbstractStage {
    public static final String PROPERTIES_KEY_HTTP = "http";
    public static final String PROPERTIES_KEY_HTTPS = "https";
    public static final String PROPERTIES_KEY_HTTPPORT = "httpport";
    public static final String PROPERTIES_KEY_HTTPSPORT = "httpsport";
    public static final String PROPERTIES_KEY_TRUST = "trust";
    public static final String PROPERTIES_KEY_CHECK_CHILDREN = "check-children";
    public static final String DEFAULT_HTTP = "true";
    public static final String DEFAULT_HTTPS = "true";
    public static final String DEFAULT_HTTPPORT = "80";
    public static final String DEFAULT_HTTPSPORT = "443";
    public static final String DEFAULT_TRUST = "none";
    public static final String DEFAULT_CHECK_CHILDREN = "true";
    private String httpURI;
    private String httpsURI;
    private TrustType trust;
    private boolean checkChildren;
    private URIMapper uriMapper;

    public AddAuthorityResolutionSEPStage(Properties properties) {
        super(properties);
    }

    public void init() throws Exception {
        String https;
        ServerConfig serverConfig = ServerConfigFactory.getSingleton();
        String httpPort = this.properties.getProperty(PROPERTIES_KEY_HTTPPORT, DEFAULT_HTTPPORT);
        String httpsPort = this.properties.getProperty(PROPERTIES_KEY_HTTPSPORT, DEFAULT_HTTPSPORT);
        String http = this.properties.getProperty(PROPERTIES_KEY_HTTP, "true");
        if (Boolean.parseBoolean(http)) {
            StringBuffer buffer = new StringBuffer().append("http://").append(serverConfig.getHostName()).append(":").append(httpPort).append(serverConfig.getServletPath());
            this.httpURI = buffer.toString();
        }
        if (Boolean.parseBoolean(https = this.properties.getProperty(PROPERTIES_KEY_HTTPS, "true"))) {
            StringBuffer buffer = new StringBuffer().append("https://").append(serverConfig.getHostName()).append(":").append(httpsPort).append(serverConfig.getServletPath());
            this.httpsURI = buffer.toString();
        }
        String trust = this.properties.getProperty(PROPERTIES_KEY_TRUST, DEFAULT_TRUST);
        this.trust = new TrustType(trust);
        String checkChildren = this.properties.getProperty(PROPERTIES_KEY_CHECK_CHILDREN, "true");
        this.checkChildren = Boolean.parseBoolean(checkChildren);
        this.uriMapper = (URIMapper)ServerConfigFactory.getSingleton().getComponentRegistry().getComponent(URIMapper.class);
    }

    public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {
        StringBuffer uri;
        if (store instanceof StoreBetterLookup && this.checkChildren && authority != null) {
            try {
                SubSegment[] children = ((StoreBetterLookup)((Object)store)).getAuthorityChildSubSegments(authority);
                if (children.length < 1) {
                    return xrd;
                }
            }
            catch (StoreException ex) {
                throw new StageException("Cannot access store to check for child subsegments.", ex);
            }
        }
        CanonicalID canonicalID = xrd.getCanonicalID();
        String canonicalIDString = null;
        if (canonicalID != null) {
            canonicalIDString = canonicalID.getValue();
        }
        String namespace = null;
        if (canonicalIDString != null) {
            namespace = canonicalIDString;
        } else if (store instanceof StoreBetterLookup) {
            String[] qxris;
            try {
                qxris = ((StoreBetterLookup)((Object)store)).getAuthorityQxris(authority);
            }
            catch (StoreException ex) {
                throw new StageException("Cannot read subsegment XRI from store.", ex);
            }
            if (qxris.length > 0) {
                namespace = qxris[0];
            }
        }
        if (namespace == null) {
            throw new StageException("Cannot determine namespace for authority resolution SEP.");
        }
        Vector<URI> uris = new Vector<URI>();
        if (this.httpURI != null) {
            uri = new StringBuffer(this.httpURI);
            this.uriMapper.completeURI(uri, namespace);
            try {
                uris.add(new URI(uri.toString()));
            }
            catch (URISyntaxException ex) {
                throw new StageException("Invalid URI: " + uri.toString());
            }
        }
        if (this.httpsURI != null) {
            uri = new StringBuffer(this.httpsURI);
            this.uriMapper.completeURI(uri, namespace);
            try {
                uris.add(new URI(uri.toString()));
            }
            catch (URISyntaxException ex) {
                throw new StageException("Invalid URI: " + uri.toString());
            }
        }
        AuthorityResolutionService authorityResolutionService = new AuthorityResolutionService(uris.toArray(new URI[uris.size()]), canonicalIDString, this.trust);
        xrd.addService((Service)authorityResolutionService);
        return xrd;
    }
}

