/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.pipeline.stages;

import java.util.Properties;
import java.util.Random;
import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.exceptions.StoreException;
import org.openxri.pipeline.stages.AbstractStage;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.CanonicalID;
import org.openxri.xml.XRD;

public class AddGUIDCanonicalIDStage
extends AbstractStage {
    private static final Random random = new Random();
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public AddGUIDCanonicalIDStage(Properties properties) {
        super(properties);
    }

    public void init() throws Exception {
    }

    public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {
        if (parentAuthority == null) {
            return xrd;
        }
        if (parentAuthority.getXrd().getNumCanonicalids() < 1) {
            return xrd;
        }
        boolean isINumber = false;
        if (subSegmentName.startsWith("!")) {
            isINumber = true;
        }
        String localCanonicalIDString = isINumber ? subSegmentName : AddGUIDCanonicalIDStage.randomCanonicalIDString();
        String canonicalIDString = parentAuthority.getXrd().getCanonicalID().getValue() + localCanonicalIDString;
        CanonicalID canonicalID = new CanonicalID(canonicalIDString);
        xrd.setCanonicalID(canonicalID);
        if (isCreate && !isINumber) {
            try {
                store.registerSubsegment(parentAuthority, localCanonicalIDString, authority);
            }
            catch (StoreException ex) {
                throw new StageException("Cannot register subsegment for CanonicalID.");
            }
        }
        return xrd;
    }

    public static String randomCanonicalIDString() {
        String str = "!";
        str = str + AddGUIDCanonicalIDStage.fourRandomChars();
        str = str + '.';
        str = str + AddGUIDCanonicalIDStage.fourRandomChars();
        str = str + '.';
        str = str + AddGUIDCanonicalIDStage.fourRandomChars();
        str = str + '.';
        str = str + AddGUIDCanonicalIDStage.fourRandomChars();
        str = str + '.';
        str = str + AddGUIDCanonicalIDStage.fourRandomChars();
        str = str + '.';
        str = str + AddGUIDCanonicalIDStage.fourRandomChars();
        str = str + '.';
        str = str + AddGUIDCanonicalIDStage.fourRandomChars();
        str = str + '.';
        str = str + AddGUIDCanonicalIDStage.fourRandomChars();
        return str;
    }

    private static String fourRandomChars() {
        return "" + AddGUIDCanonicalIDStage.randomHexChar() + AddGUIDCanonicalIDStage.randomHexChar() + AddGUIDCanonicalIDStage.randomHexChar() + AddGUIDCanonicalIDStage.randomHexChar();
    }

    private static char randomHexChar() {
        return hexchars[random.nextInt(hexchars.length)];
    }
}

