/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.pipeline.stages;

import java.util.Map;
import java.util.Properties;
import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.exceptions.StoreException;
import org.openxri.pipeline.stages.AbstractStage;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreAttributable;
import org.openxri.xml.CanonicalID;
import org.openxri.xml.XRD;

public class AddSerialCanonicalIDStage
extends AbstractStage {
    public static final String ATTRIBUTES_KEY_LAST_CANONICALID = "last-canonicalid";

    public AddSerialCanonicalIDStage(Properties properties) {
        super(properties);
    }

    public void init() throws Exception {
    }

    public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {
        if (!(store instanceof StoreAttributable)) {
            throw new StageException("Cannot use this store implementation.");
        }
        StoreAttributable storeAttributable = (StoreAttributable)((Object)store);
        if (parentAuthority == null) {
            return xrd;
        }
        if (parentAuthority.getXrd().getNumCanonicalids() < 1) {
            return xrd;
        }
        boolean isINumber = false;
        if (subSegmentName.startsWith("!")) {
            isINumber = true;
        }
        String canonicalIDString = null;
        int canonicalIDValue = -1;
        if (!isINumber) {
            try {
                canonicalIDString = storeAttributable.getAuthorityAttributes(parentAuthority).get(ATTRIBUTES_KEY_LAST_CANONICALID);
                canonicalIDValue = Integer.parseInt(canonicalIDString);
                ++canonicalIDValue;
            }
            catch (StoreException ex) {
                throw new StageException("Cannot read authority attribute from store.", ex);
            }
            catch (NullPointerException ex) {
                canonicalIDValue = 0;
            }
            catch (NumberFormatException ex) {
                canonicalIDValue = 0;
            }
        }
        String localCanonicalIDString = isINumber ? subSegmentName : "!" + Integer.toString(canonicalIDValue);
        canonicalIDString = parentAuthority.getXrd().getCanonicalidAt(0).getValue() + localCanonicalIDString;
        CanonicalID canonicalID = new CanonicalID(canonicalIDString);
        if (!isINumber) {
            try {
                Map<String, String> attributes = storeAttributable.getAuthorityAttributes(parentAuthority);
                attributes.put(ATTRIBUTES_KEY_LAST_CANONICALID, Integer.toString(canonicalIDValue));
                storeAttributable.setAuthorityAttributes(parentAuthority, attributes);
            }
            catch (StoreException ex) {
                throw new StageException("Cannot write authority attribute to store.", ex);
            }
        }
        xrd.addCanonicalID(canonicalID);
        if (isCreate && !isINumber) {
            try {
                store.registerSubsegment(parentAuthority, localCanonicalIDString, authority);
            }
            catch (StoreException ex) {
                throw new StageException("Cannot register subsegment for CanonicalID.");
            }
        }
        return xrd;
    }
}

