/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.pipeline.stages;

import java.util.ArrayList;
import java.util.Properties;
import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.pipeline.stages.AbstractStage;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreAttributable;
import org.openxri.xml.XRD;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class AddXMLElementStage
extends AbstractStage {
    public static final String PROPERTIES_KEY_ELEMENTNAME = "elementname";
    public static final String PROPERTIES_KEY_ELEMENTVALUE = "elementvalue";
    public static final String DEFAULT_ELEMENTVALUE = "";
    private String elementName;
    private String elementValue;
    private String[] attributeNames;
    private String[] attributeValues;

    public AddXMLElementStage(Properties properties) {
        super(properties);
    }

    public void init() throws Exception {
        String elementValue;
        String elementName = this.properties.getProperty(PROPERTIES_KEY_ELEMENTNAME);
        if (elementName == null) {
            throw new StageException("Required property elementname not found.");
        }
        this.elementName = elementName;
        this.elementValue = elementValue = this.properties.getProperty(PROPERTIES_KEY_ELEMENTVALUE, DEFAULT_ELEMENTVALUE);
        ArrayList<String> attributeNames = new ArrayList<String>();
        ArrayList<String> attributeValues = new ArrayList<String>();
        for (Object key : this.properties.keySet()) {
            String attributeName = (String)key;
            String attributeValue = this.properties.getProperty(attributeName);
            if (attributeName.equals(PROPERTIES_KEY_ELEMENTNAME) || attributeName.equals(PROPERTIES_KEY_ELEMENTVALUE) || attributeValue == null) continue;
            attributeNames.add(attributeName);
            attributeValues.add(attributeValue);
        }
        this.attributeNames = attributeNames.toArray(new String[attributeNames.size()]);
        this.attributeValues = attributeValues.toArray(new String[attributeValues.size()]);
    }

    public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {
        if (!(store instanceof StoreAttributable)) {
            throw new StageException("Cannot use this store implementation.");
        }
        StoreAttributable storeAttributable = (StoreAttributable)((Object)store);
        Element xrdElement = xrd.getDOM();
        Document document = xrdElement.getOwnerDocument();
        Element element = document.createElement(this.elementName);
        if (this.elementValue != null) {
            Text text = document.createTextNode(this.elementValue);
            element.appendChild(text);
        }
        for (int i = 0; i < this.attributeNames.length; ++i) {
            Attr attr = document.createAttribute(this.attributeNames[i]);
            attr.setNodeValue(this.attributeValues[i]);
        }
        try {
            xrdElement.appendChild(element);
            xrd = new XRD(xrdElement, false);
        }
        catch (Exception ex) {
            throw new StageException("Unable to parse modified XRD.", ex);
        }
        return xrd;
    }
}

