/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xri3.impl;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class IRIUtils {
    private static final int[] HEXCHARS = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final String RFC3986_GEN_DELIMS = ":/?#[]@";
    private static final String RFC3986_SUB_DELIMS = "!$&'()*+,;=";
    private static final String RFC3986_RESERVED = ":/?#[]@!$&'()*+,;=";
    private static final String ALPHA_LOWER = "abcdefghijklmnopqrstuvwxyz";
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyz" + "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final int end = 0;
    private static final int ill = 1;
    private static final int asc = 2;
    private static final int trl = 3;
    private static final int by2 = 4;
    private static final int e0 = 5;
    private static final int by3 = 6;
    private static final int ed = 7;
    private static final int p13 = 8;
    private static final int by4 = 9;
    private static final int p16 = 10;
    private static final int notal = 0;
    private static final int unres = 1;
    private static final int gendl = 2;
    private static final int subdl = 3;
    private static final int slash = 4;
    private static final int[] URICHARS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0};
    private static final int[] UTF8lead = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 6, 6, 8, 9, 9, 9, 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

    public static String IRItoXRI(String iri) {
        int cp;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < iri.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)iri, (int)i);
            if (cp == 37) {
                int percentEnc = IRIUtils.decodeHex(iri, i);
                if (percentEnc == -1) {
                    throw new RuntimeException("Invalid percent encoding encountered in IRI");
                }
                switch (percentEnc) {
                    case 47: {
                        sb.append('/');
                        break;
                    }
                    case 63: {
                        sb.append('?');
                        break;
                    }
                    case 35: {
                        sb.append('#');
                        break;
                    }
                    case 37: {
                        sb.append('%');
                        break;
                    }
                    default: {
                        sb.append(iri.substring(i, i + 3));
                    }
                }
                i += 2;
                continue;
            }
            sb.append(iri.substring(i, i + UTF16.getCharCount((int)cp)));
        }
        return sb.toString();
    }

    public static String URItoIRI(String uri) throws UnsupportedEncodingException {
        int uriLength = uri.length();
        byte[] bb = new byte[uriLength];
        int bbIndex = 0;
        byte[] u8buf = new byte[4];
        int i = 0;
        while (i < uriLength) {
            int cpVal;
            char cp = uri.charAt(i);
            if (cp > '\u007f') {
                throw new RuntimeException("Non ASCII character encountered in URI");
            }
            if (cp != '%') {
                bb[bbIndex++] = (byte)cp;
                ++i;
                continue;
            }
            try {
                cpVal = IRIUtils.decodeHex(uri, i);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Invalid percent encoding encountered in URI: " + e.getMessage());
            }
            if (cpVal <= 127) {
                int flg = URICHARS[cpVal];
                if (cpVal == 37 || flg == 2 || flg == 3 || flg == 0) {
                    bb[bbIndex++] = (byte)uri.charAt(i++);
                    bb[bbIndex++] = (byte)uri.charAt(i++);
                    bb[bbIndex++] = (byte)uri.charAt(i++);
                    continue;
                }
                bb[bbIndex++] = (byte)cpVal;
                i += 3;
                continue;
            }
            int n = IRIUtils.countUTF8Sequence(uri, i, u8buf);
            if (n > 0) {
                if (IRIUtils.hasBiDiChar(new String(u8buf, 0, n, "UTF-8"))) {
                    bb[bbIndex++] = (byte)uri.charAt(i++);
                    bb[bbIndex++] = (byte)uri.charAt(i++);
                    bb[bbIndex++] = (byte)uri.charAt(i++);
                    continue;
                }
                for (int j = 0; j < n; ++j) {
                    bb[bbIndex++] = u8buf[j];
                }
                i += n * 3;
                continue;
            }
            bb[bbIndex++] = (byte)uri.charAt(i++);
            bb[bbIndex++] = (byte)uri.charAt(i++);
            bb[bbIndex++] = (byte)uri.charAt(i++);
        }
        return new String(bb, 0, bbIndex, "UTF-8");
    }

    public static String IRItoURI(String iri) {
        int cp;
        int iriLen = iri.length();
        StringBuffer sb = new StringBuffer(iriLen * 2);
        for (int i = 0; i < iriLen; i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)iri, (int)i);
            if (IRIUtils.isUCSCharOrIPrivate(cp)) {
                sb.append(IRIUtils.toUTF8PercentEncoded(cp));
                continue;
            }
            UTF16.append((StringBuffer)sb, (int)cp);
        }
        return sb.toString();
    }

    protected static String toUTF8PercentEncoded(int cp) {
        String s = null;
        try {
            s = URLEncoder.encode(UCharacter.toString((int)cp), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return s;
    }

    protected static boolean isUCSCharOrIPrivate(int cp) {
        return IRIUtils.isUCSChar(cp) || IRIUtils.isIPrivate(cp);
    }

    protected static boolean isUCSChar(int cp) {
        return cp >= 160 && cp <= 55295 || cp >= 63744 && cp <= 64975 || cp >= 65008 && cp <= 65519 || cp >= 65536 && cp <= 131069 || cp >= 131072 && cp <= 196605 || cp >= 196608 && cp <= 262141 || cp >= 262144 && cp <= 327677 || cp >= 327680 && cp <= 393213 || cp >= 393216 && cp <= 458749 || cp >= 458752 && cp <= 524285 || cp >= 524288 && cp <= 589821 || cp >= 589824 && cp <= 655357 || cp >= 655360 && cp <= 720893 || cp >= 720896 && cp <= 786429 || cp >= 786432 && cp <= 851965 || cp >= 851968 && cp <= 917501 || cp >= 917504 && cp <= 983037;
    }

    protected static boolean isIPrivate(int cp) {
        return cp >= 57344 && cp <= 63743 || cp >= 983040 && cp <= 1048573 || cp >= 0x100000 && cp <= 1114109;
    }

    public static String XRItoIRI(String s, boolean inXref) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                sb.append("%25");
                continue;
            }
            if (inXref) {
                if (c == '#') {
                    sb.append("%23");
                    continue;
                }
                if (c == '?') {
                    sb.append("%3F");
                    continue;
                }
                if (c == '/') {
                    sb.append("%2F");
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static int countUTF8Sequence(String in, int inIndex, byte[] u8buf) {
        int[] c = new int[4];
        if (!IRIUtils.isPercentEncoded(in, inIndex)) {
            return 0;
        }
        c[0] = IRIUtils.decodeHex(in, inIndex);
        switch (UTF8lead[c[0]]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return 0;
            }
            case 4: {
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3)) {
                    return 0;
                }
                c[1] = IRIUtils.decodeHex(in, inIndex);
                if (UTF8lead[c[1]] != 3) {
                    return 0;
                }
                u8buf[0] = (byte)c[0];
                u8buf[1] = (byte)c[1];
                return 2;
            }
            case 5: {
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3) || !IRIUtils.isPercentEncoded(in, inIndex + 3)) {
                    return 0;
                }
                c[1] = IRIUtils.decodeHex(in, inIndex);
                c[2] = IRIUtils.decodeHex(in, inIndex += 3);
                if ((c[1] & 0xE0) != 160 || UTF8lead[c[2]] != 3) {
                    return 0;
                }
                u8buf[0] = (byte)c[0];
                u8buf[1] = (byte)c[1];
                u8buf[2] = (byte)c[2];
                return 3;
            }
            case 6: {
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3) || !IRIUtils.isPercentEncoded(in, inIndex + 3)) {
                    return 0;
                }
                c[1] = IRIUtils.decodeHex(in, inIndex);
                c[2] = IRIUtils.decodeHex(in, inIndex += 3);
                if (UTF8lead[c[1]] != 3 || UTF8lead[c[2]] != 3) {
                    return 0;
                }
                u8buf[0] = (byte)c[0];
                u8buf[1] = (byte)c[1];
                u8buf[2] = (byte)c[2];
                return 3;
            }
            case 7: {
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3) || !IRIUtils.isPercentEncoded(in, inIndex + 3)) {
                    return 0;
                }
                c[1] = IRIUtils.decodeHex(in, inIndex);
                c[2] = IRIUtils.decodeHex(in, inIndex += 3);
                if ((c[1] & 0xE0) != 128 || UTF8lead[c[2]] != 3) {
                    return 0;
                }
                u8buf[0] = (byte)c[0];
                u8buf[1] = (byte)c[1];
                u8buf[2] = (byte)c[2];
                return 3;
            }
            case 8: {
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3)) {
                    return 0;
                }
                c[1] = IRIUtils.decodeHex(in, inIndex);
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3)) {
                    return 0;
                }
                c[2] = IRIUtils.decodeHex(in, inIndex);
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3)) {
                    return 0;
                }
                c[3] = IRIUtils.decodeHex(in, inIndex);
                if (c[1] < 144 || 191 < c[1] || UTF8lead[c[2]] != 3 || UTF8lead[c[3]] != 3) {
                    return 0;
                }
                u8buf[0] = (byte)c[0];
                u8buf[1] = (byte)c[1];
                u8buf[2] = (byte)c[2];
                u8buf[3] = (byte)c[3];
                return 4;
            }
            case 9: {
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3)) {
                    return 0;
                }
                c[1] = IRIUtils.decodeHex(in, inIndex);
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3)) {
                    return 0;
                }
                c[2] = IRIUtils.decodeHex(in, inIndex);
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3)) {
                    return 0;
                }
                c[3] = IRIUtils.decodeHex(in, inIndex);
                if (UTF8lead[c[1]] != 3 || UTF8lead[c[2]] != 3 || UTF8lead[c[3]] != 3) {
                    return 0;
                }
                u8buf[0] = (byte)c[0];
                u8buf[1] = (byte)c[1];
                u8buf[2] = (byte)c[2];
                u8buf[3] = (byte)c[3];
                return 4;
            }
            case 10: {
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3)) {
                    return 0;
                }
                c[1] = IRIUtils.decodeHex(in, inIndex);
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3)) {
                    return 0;
                }
                c[2] = IRIUtils.decodeHex(in, inIndex);
                if (!IRIUtils.isPercentEncoded(in, inIndex += 3)) {
                    return 0;
                }
                c[3] = IRIUtils.decodeHex(in, inIndex);
                if ((c[1] & 0xF0) != 128 || UTF8lead[c[2]] != 3 || UTF8lead[c[3]] != 3) {
                    return 0;
                }
                u8buf[0] = (byte)c[0];
                u8buf[1] = (byte)c[1];
                u8buf[2] = (byte)c[2];
                u8buf[3] = (byte)c[3];
                return 4;
            }
        }
        return 0;
    }

    private static String getHex(String s, int index) {
        if (s.length() < index + 3) {
            return null;
        }
        if (s.charAt(index) != '%') {
            return null;
        }
        char c1 = Character.toUpperCase(s.charAt(index + 1));
        char c2 = Character.toUpperCase(s.charAt(index + 2));
        if (c1 >= HEXCHARS.length || HEXCHARS[c1] == -1 || c2 >= HEXCHARS.length || HEXCHARS[c2] == -1) {
            return null;
        }
        return s.substring(index, index + 3);
    }

    public static int decodeHex(String s, int index) {
        if (s.length() < index + 3) {
            throw new IllegalArgumentException("Incomplete percent escape");
        }
        if (s.charAt(index) != '%') {
            return -1;
        }
        char c1 = Character.toUpperCase(s.charAt(index + 1));
        char c2 = Character.toUpperCase(s.charAt(index + 2));
        if (c1 >= HEXCHARS.length || c2 >= HEXCHARS.length) {
            throw new IllegalArgumentException("Illegal hex characters");
        }
        int c1val = HEXCHARS[c1];
        int c2val = HEXCHARS[c2];
        if (c1val == -1 || c2val == -1) {
            throw new IllegalArgumentException("Illegal hex characters");
        }
        return c1val * 16 + c2val;
    }

    private static boolean isPercentEncoded(String s, int index) {
        if (s.length() < index + 3) {
            return false;
        }
        if (s.charAt(index) != '%') {
            return false;
        }
        char c1 = Character.toUpperCase(s.charAt(index + 1));
        char c2 = Character.toUpperCase(s.charAt(index + 2));
        return c1 < HEXCHARS.length && c2 < HEXCHARS.length;
    }

    private static boolean hasBiDiChar(String s) {
        int cp;
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            if (cp != 8206 && cp != 8207 && cp != 8234 && cp != 8235 && cp != 8237 && cp != 8238 && cp != 8236) continue;
            return true;
        }
        return false;
    }
}

