/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.config.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.config.Component;
import org.openxri.config.ComponentRegistry;
import org.openxri.config.impl.XMLServerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLComponentRegistry
implements ComponentRegistry {
    private static Log log = LogFactory.getLog((String)XMLComponentRegistry.class.getName());
    private List<Component> componentList = new ArrayList<Component>();
    private Map<Class<? extends Component>, Component> componentMap = new HashMap<Class<? extends Component>, Component>();

    XMLComponentRegistry(List<XMLServerConfig.ComponentConfig> componentConfigs, ClassLoader classLoader) {
        this.load(componentConfigs, classLoader);
    }

    XMLComponentRegistry(List<XMLServerConfig.ComponentConfig> componentConfigs) {
        this.load(componentConfigs, Thread.currentThread().getContextClassLoader());
    }

    private void load(List<XMLServerConfig.ComponentConfig> componentConfigs, ClassLoader classLoader) {
        for (XMLServerConfig.ComponentConfig componentConfig : componentConfigs) {
            Component component;
            Class<?> implementationClass;
            Class<?> interfaceClass;
            String interfaceName = componentConfig.getInterfaceName();
            try {
                interfaceClass = classLoader.loadClass(interfaceName);
            }
            catch (ClassNotFoundException ex) {
                log.error((Object)("Server component interface not found: " + interfaceName), (Throwable)ex);
                continue;
            }
            String implementationName = componentConfig.getClassName();
            try {
                implementationClass = classLoader.loadClass(implementationName);
            }
            catch (ClassNotFoundException ex) {
                log.error((Object)("Server component implementation not found: " + implementationName), (Throwable)ex);
                continue;
            }
            Properties properties = componentConfig.getProperties();
            try {
                Class[] constructorArgs = new Class[]{Properties.class};
                Constructor<?> constructor = implementationClass.getConstructor(constructorArgs);
                component = (Component)constructor.newInstance(properties);
            }
            catch (NoSuchMethodException ex) {
                log.error((Object)("Server component " + implementationName + " does not have a constructor that takes a java.util.Properties object."), (Throwable)ex);
                continue;
            }
            catch (InstantiationException ex) {
                log.error((Object)("Cannot instantiate component " + implementationName + "."), (Throwable)ex);
                continue;
            }
            catch (IllegalAccessException ex) {
                log.error((Object)("Illegal access to constructor of component " + implementationName + "."), (Throwable)ex);
                continue;
            }
            catch (InvocationTargetException ex) {
                log.error((Object)("Cannot invoke constructor of component " + implementationName + "."), (Throwable)ex);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("Cannot construct component " + implementationName + "."), (Throwable)ex);
                continue;
            }
            this.componentList.add(component);
            this.componentMap.put(interfaceClass, component);
        }
    }

    @Override
    public void init() {
        for (Component component : this.componentList) {
            try {
                component.init();
            }
            catch (Exception ex) {
                log.error((Object)("Cannot init component " + component.getClass().getName() + "."), (Throwable)ex);
            }
        }
    }

    @Override
    public List<Component> getComponents() {
        if (this.componentList == null) {
            throw new IllegalStateException("Not initialized.");
        }
        return this.componentList;
    }

    @Override
    public Component getComponent(Class<? extends Component> interfaceClass) {
        if (this.componentMap == null) {
            throw new IllegalStateException("Not initialized.");
        }
        return this.componentMap.get(interfaceClass);
    }
}

