/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.factories;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.config.ProxyConfig;
import org.openxri.config.impl.PropertiesProxyConfig;

public class ProxyConfigFactory {
    private static Log log = LogFactory.getLog((String)ProxyConfigFactory.class.getName());
    public static final String PROXY_CONFIG_CLASS = "proxy.config.class";
    public static final String DEFAULT_PROXY_CONFIG_CLASS = PropertiesProxyConfig.class.getName();
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static ProxyConfig instance = null;

    private ProxyConfigFactory() {
    }

    public static synchronized ProxyConfig initSingleton(ServletContext servletContext, Properties properties) throws Exception {
        String className = properties.getProperty(PROXY_CONFIG_CLASS);
        if (className == null) {
            className = DEFAULT_PROXY_CONFIG_CLASS;
        }
        log.info((Object)("Using ProxyConfig implementation class: " + className + "."));
        Class<?> clazz = classLoader.loadClass(className);
        Constructor<?> constructor = clazz.getConstructor(ServletContext.class, Properties.class);
        instance = (ProxyConfig)constructor.newInstance(servletContext, properties);
        instance.init();
        log.debug((Object)("Successfully constructed ProxyConfig implementation: " + className));
        return instance;
    }

    public static synchronized ProxyConfig initSingleton(ServletConfig servletConfig) throws Exception {
        Properties properties = new Properties();
        Enumeration e = servletConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String initParameterName = (String)e.nextElement();
            properties.setProperty(initParameterName, servletConfig.getInitParameter(initParameterName));
        }
        return ProxyConfigFactory.initSingleton(servletConfig.getServletContext(), properties);
    }

    public static synchronized ProxyConfig initSingleton(FilterConfig filterConfig) throws Exception {
        Properties properties = new Properties();
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String initParameterName = (String)e.nextElement();
            properties.setProperty(initParameterName, filterConfig.getInitParameter(initParameterName));
        }
        return ProxyConfigFactory.initSingleton(filterConfig.getServletContext(), properties);
    }

    public static synchronized ProxyConfig getSingleton() {
        return instance;
    }

    public static synchronized ClassLoader getClassLoader() {
        return classLoader;
    }

    public static synchronized void setClassLoader(ClassLoader classLoader) {
        ProxyConfigFactory.classLoader = classLoader;
    }
}

