/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.pipeline.stages;

import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.pipeline.stages.AbstractStage;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

public class AddExpiresAbsoluteStage
extends AbstractStage {
    public static final String PROPERTIES_KEY_EXPIRES = "expires";
    public static final String DEFAULT_EXPIRES = "2099-01-01";
    private Date date;

    public AddExpiresAbsoluteStage(Properties properties) {
        super(properties);
    }

    public void init() throws Exception {
        String date = this.properties.getProperty(PROPERTIES_KEY_EXPIRES, DEFAULT_EXPIRES);
        this.date = DateFormat.getInstance().parse(date);
    }

    public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {
        if (this.date == null) {
            throw new StageException("Not initialized.");
        }
        xrd.setExpires(this.date);
        return xrd;
    }
}

