/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.pipeline.stages;

import java.util.Map;
import java.util.Properties;
import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.exceptions.StoreException;
import org.openxri.pipeline.stages.AbstractStage;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreAttributable;
import org.openxri.xml.XRD;

public class InheritAttributesStage
extends AbstractStage {
    public static final String PROPERTIES_KEY_ATTRIBUTES = "attributes";
    private String[] attributes;

    public InheritAttributesStage(Properties properties) {
        super(properties);
    }

    public void init() throws Exception {
        String value = this.properties.getProperty(PROPERTIES_KEY_ATTRIBUTES);
        if (value == null) {
            throw new StageException("Required property attributes not found.");
        }
        this.attributes = value.split("[ ,;:]");
    }

    public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {
        if (!(store instanceof StoreAttributable)) {
            throw new StageException("Cannot use this store implementation.");
        }
        StoreAttributable storeAttributable = (StoreAttributable)((Object)store);
        for (String attribute : this.attributes) {
            try {
                Map<String, String> attributes = storeAttributable.getAuthorityAttributes(parentAuthority);
                storeAttributable.setAuthorityAttributes(authority, attributes);
            }
            catch (StoreException ex) {
                throw new StageException("Cannot set attribute for authority.");
            }
        }
        return xrd;
    }
}

