/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.servlet;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.config.ProxyConfig;
import org.openxri.config.impl.PropertiesProxyConfig;
import org.openxri.factories.ProxyConfigFactory;
import org.openxri.proxy.Proxy;
import org.openxri.proxy.ProxyException;

public class ProxyServlet
extends HttpServlet {
    protected static Log log = LogFactory.getLog((String)ProxyServlet.class.getName());
    public static final String PROXY_CONFIG_CLASS = "proxy.config.class";
    public static final String DEFAULT_PROXY_CONFIG_CLASS = PropertiesProxyConfig.class.getName();
    private ProxyConfig proxyConfig;
    private Proxy moProxy;

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        try {
            this.proxyConfig = ProxyConfigFactory.initSingleton(servletConfig);
        }
        catch (Exception ex) {
            throw new ServletException("Cannot initialize proxy configuration.", (Throwable)ex);
        }
        try {
            this.init(this.proxyConfig);
        }
        catch (ProxyException ex) {
            throw new ServletException("Unable to initialize proxy.", (Throwable)ex);
        }
    }

    public void init(ProxyConfig oConfig) throws ProxyException {
        Class<?> implementationClass;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String implementationName = this.proxyConfig.getProxyImplClass();
        try {
            implementationClass = classLoader.loadClass(implementationName);
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)("Proxy implementation not found: " + implementationName), (Throwable)ex);
            throw new ProxyException("Proxy implementation not found: " + implementationName, ex);
        }
        try {
            Class[] constructorArgs = new Class[]{ProxyConfig.class};
            Constructor<?> constructor = implementationClass.getConstructor(constructorArgs);
            this.moProxy = (Proxy)constructor.newInstance(this.proxyConfig);
        }
        catch (NoSuchMethodException ex) {
            log.error((Object)("Proxy " + implementationName + " does not have a constructor that takes a ProxyConfig object."), (Throwable)ex);
            throw new ProxyException("Proxy " + implementationName + " does not have a constructor that takes a ProxyConfig object.", ex);
        }
        catch (InstantiationException ex) {
            log.error((Object)("Cannot instantiate proxy " + implementationName + "."), (Throwable)ex);
            throw new ProxyException("Cannot instantiate proxy " + implementationName + ".", ex);
        }
        catch (IllegalAccessException ex) {
            log.error((Object)("Illegal access to constructor of proxy " + implementationName + "."), (Throwable)ex);
            throw new ProxyException("Illegal access to constructor of proxy " + implementationName + ".", ex);
        }
        catch (InvocationTargetException ex) {
            log.error((Object)("Cannot invoke constructor of proxy " + implementationName + "."), (Throwable)ex);
            throw new ProxyException("Cannot invoke constructor of proxy " + implementationName + ".", ex);
        }
        catch (Exception ex) {
            log.error((Object)("Cannot construct proxy " + implementationName + "."), (Throwable)ex);
            throw new ProxyException("Cannot construct proxy " + implementationName + ".", ex);
        }
        this.moProxy.init();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.moProxy.process(request, response);
    }
}

