/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.store.impl.db;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.openxri.XRIAuthority;
import org.openxri.config.PipelineRegistry;
import org.openxri.config.ServerConfig;
import org.openxri.exceptions.StoreDuplicateEntryException;
import org.openxri.exceptions.StoreException;
import org.openxri.exceptions.StoreInternalException;
import org.openxri.exceptions.StoreNotFoundException;
import org.openxri.factories.ServerConfigFactory;
import org.openxri.pipeline.Pipeline;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreAttributable;
import org.openxri.store.StoreBetterLookup;
import org.openxri.store.StoreEditable;
import org.openxri.store.StoreLookup;
import org.openxri.store.StoreMountable;
import org.openxri.store.StoreResettable;
import org.openxri.store.StoreStatistics;
import org.openxri.store.SubSegment;
import org.openxri.store.impl.AbstractStore;
import org.openxri.store.impl.db.DbAuthority;
import org.openxri.store.impl.db.DbStoreData;
import org.openxri.store.impl.db.DbSubSegment;
import org.openxri.xml.XRD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseStore
extends AbstractStore
implements Store,
StoreLookup,
StoreBetterLookup,
StoreEditable,
StoreResettable,
StoreAttributable,
StoreMountable,
StoreStatistics {
    private static final Log log = LogFactory.getLog((String)DatabaseStore.class.getName());
    public static final int MAX_ALIAS_RECURSION = 30;
    protected Configuration configuration;
    protected SessionFactory sessionFactory;

    public DatabaseStore(Properties properties) {
        super(properties);
    }

    @Override
    public synchronized void init() throws StoreException {
        log.trace((Object)"init()");
        try {
            this.configuration = new Configuration();
            this.configuration.setProperties(this.properties);
            this.configuration.addClass(DbAuthority.class);
            this.configuration.addClass(DbSubSegment.class);
            this.configuration.addClass(DbStoreData.class);
            this.initSessionFactory();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            throw new StoreInternalException(ex, "Cannot initialize Hibernate");
        }
        log.trace((Object)"Done.");
    }

    private synchronized void initSessionFactory() {
        this.sessionFactory = this.configuration.buildSessionFactory();
    }

    public synchronized void close() {
        log.trace((Object)"close()");
        this.sessionFactory.close();
        this.sessionFactory = null;
    }

    public synchronized boolean isClosed() {
        return this.sessionFactory == null || this.sessionFactory.isClosed();
    }

    public synchronized SessionFactory getSessionFactory() throws StoreException {
        if (this.sessionFactory != null && !this.sessionFactory.isClosed()) {
            return this.sessionFactory;
        }
        this.initSessionFactory();
        if (this.sessionFactory != null && !this.sessionFactory.isClosed()) {
            return this.sessionFactory;
        }
        throw new StoreInternalException("Database not available.");
    }

    public synchronized void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public synchronized SubSegment[] listRootSubSegments() throws StoreException {
        List<DbSubSegment> subSegments;
        log.trace((Object)"listRootSubSegments()");
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            subSegments = DbSubSegment.AllRoot((org.hibernate.Session)session);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot list root subsegments.");
        }
        SubSegment[] result = new ArrayList<DbSubSegment>(subSegments).toArray(new SubSegment[subSegments.size()]);
        log.trace((Object)"Done.");
        return result;
    }

    @Override
    public synchronized Authority createAuthority(XRD xrd) throws StoreException {
        XRD newXRD;
        DbAuthority authority;
        log.trace((Object)"createAuthority()");
        ServerConfig serverConfig = ServerConfigFactory.getSingleton();
        PipelineRegistry pipelineRegistry = serverConfig == null ? null : serverConfig.getPipelineRegistry();
        Pipeline createPipeline = null;
        if (pipelineRegistry != null) {
            createPipeline = pipelineRegistry.getDefaultCreatePipeline();
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            authority = new DbAuthority();
            session.save((Object)authority);
            session.flush();
            session.refresh((Object)authority);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        try {
            newXRD = createPipeline != null ? createPipeline.execute(this, xrd, null, null, null, authority, true) : xrd;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot execute pipeline.");
        }
        session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            authority.setXrd(newXRD);
            session.update((Object)authority);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return authority;
    }

    @Override
    public synchronized SubSegment createRootSubSegment(String name, XRD xrd) throws StoreException {
        DbSubSegment subSegment;
        XRD newXRD;
        DbAuthority authority;
        log.trace((Object)"createRootSubSegment()");
        ServerConfig serverConfig = ServerConfigFactory.getSingleton();
        PipelineRegistry pipelineRegistry = serverConfig == null ? null : serverConfig.getPipelineRegistry();
        Pipeline createPipeline = null;
        if (pipelineRegistry != null) {
            createPipeline = pipelineRegistry.getDefaultCreatePipeline();
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            if (DbSubSegment.RootByName((org.hibernate.Session)session, name) != null) {
                throw new StoreDuplicateEntryException("Root subsegment exists already.");
            }
            authority = new DbAuthority();
            session.save((Object)authority);
            session.flush();
            session.refresh((Object)authority);
            session.getTransaction().commit();
        }
        catch (StoreException ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        try {
            newXRD = createPipeline != null ? createPipeline.execute(this, xrd, null, null, null, authority, true) : xrd;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot execute pipeline.");
        }
        session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            authority.setXrd(newXRD);
            session.update((Object)authority);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            subSegment = new DbSubSegment();
            subSegment.setName(name);
            subSegment.setAuthority(authority);
            session.save((Object)subSegment);
            session.flush();
            session.refresh((Object)subSegment);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return subSegment;
    }

    @Override
    public synchronized void deleteRootSubSegment(String name) throws StoreException {
        log.trace((Object)"deleteRootSubSegment()");
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DbSubSegment rootSubSegment = DbSubSegment.RootByName((org.hibernate.Session)session, name);
            if (rootSubSegment == null) {
                throw new StoreNotFoundException("Root subsegment does not exist.");
            }
            session.delete((Object)rootSubSegment);
            session.flush();
            session.getTransaction().commit();
        }
        catch (StoreException ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public synchronized void deleteAuthority(Authority authority) throws StoreException {
        log.trace((Object)"deleteAuthority()");
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            session.delete((Object)authority);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public synchronized SubSegment registerSubsegment(Authority parentAuthority, String subSegmentName, XRD xrd) throws StoreException {
        DbSubSegment subSegment;
        XRD newXRD;
        DbAuthority authority;
        log.trace((Object)("registerSubsegment(" + subSegmentName + ")"));
        if (parentAuthority == null) {
            throw new NullPointerException();
        }
        if (!(parentAuthority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Parent authority is not from this store.");
        }
        ServerConfig serverConfig = ServerConfigFactory.getSingleton();
        PipelineRegistry pipelineRegistry = serverConfig == null ? null : serverConfig.getPipelineRegistry();
        Pipeline createPipeline = null;
        String pipelineName = this.getAuthorityAttributes(parentAuthority).get("override-create-pipeline");
        if (pipelineRegistry != null && pipelineName != null) {
            createPipeline = pipelineRegistry.getPipelineByName(pipelineName);
        }
        if (pipelineRegistry != null && createPipeline == null) {
            createPipeline = pipelineRegistry.getDefaultCreatePipeline();
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, parentAuthority);
            if (DbSubSegment.ByParentAndName((org.hibernate.Session)session, (DbAuthority)parentAuthority, subSegmentName) != null) {
                throw new StoreDuplicateEntryException("Subsegment exists already.");
            }
            authority = new DbAuthority();
            session.save((Object)authority);
            session.flush();
            session.refresh((Object)authority);
            session.getTransaction().commit();
        }
        catch (StoreException ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        try {
            newXRD = createPipeline != null ? createPipeline.execute(this, xrd, null, parentAuthority, subSegmentName, authority, true) : xrd;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot execute pipeline.");
        }
        session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            authority.setXrd(newXRD);
            session.update((Object)authority);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, parentAuthority);
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            subSegment = new DbSubSegment();
            subSegment.setParent((DbAuthority)parentAuthority);
            subSegment.setName(subSegmentName);
            subSegment.setAuthority(authority);
            ((DbAuthority)parentAuthority).getChildren().add(subSegment);
            authority.getSubSegments().add(subSegment);
            session.save((Object)subSegment);
            session.flush();
            session.refresh((Object)subSegment);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return subSegment;
    }

    @Override
    public synchronized SubSegment registerSubsegment(Authority parentAuthority, String subSegmentName, Authority authority) throws StoreException {
        DbSubSegment subSegment;
        log.trace((Object)("registerSubsegment(" + subSegmentName + ")"));
        if (parentAuthority != null && !(parentAuthority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Parent authority is not from this store.");
        }
        if (authority != null && !(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, parentAuthority);
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            if (parentAuthority != null && (subSegment = DbSubSegment.ByParentAndName((org.hibernate.Session)session, (DbAuthority)parentAuthority, subSegmentName)) != null) {
                throw new StoreDuplicateEntryException("Subsegment exists already.");
            }
            if (authority != null && parentAuthority != null && authority.equals(parentAuthority)) {
                authority = parentAuthority;
            }
            subSegment = new DbSubSegment();
            subSegment.setParent((DbAuthority)parentAuthority);
            subSegment.setName(subSegmentName);
            subSegment.setAuthority((DbAuthority)authority);
            if (parentAuthority != null) {
                ((DbAuthority)parentAuthority).getChildren().add(subSegment);
            }
            if (authority != null) {
                ((DbAuthority)authority).getSubSegments().add(subSegment);
            }
            session.save((Object)subSegment);
            session.flush();
            session.refresh((Object)subSegment);
            session.getTransaction().commit();
        }
        catch (StoreException ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return subSegment;
    }

    @Override
    public synchronized void releaseSubSegment(SubSegment subSegment) throws StoreException {
        log.trace((Object)"releaseSubsegment()");
        if (subSegment == null) {
            throw new NullPointerException();
        }
        if (!(subSegment instanceof DbSubSegment)) {
            throw new StoreNotFoundException("Subsegment is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            session.delete((Object)subSegment);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public synchronized SubSegment findRootSubSegment(String namespace) throws StoreException {
        DbSubSegment rootSubSegment;
        log.trace((Object)"findRootSubSegment()");
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            rootSubSegment = DbSubSegment.RootByName((org.hibernate.Session)session, namespace);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return rootSubSegment;
    }

    @Override
    public synchronized SubSegment findSubSegment(Authority parentAuthority, String name) throws StoreException {
        DbSubSegment subSegment;
        log.trace((Object)"findSubSegment()");
        if (parentAuthority == null) {
            throw new NullPointerException();
        }
        if (!(parentAuthority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Parent authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, parentAuthority);
            subSegment = DbSubSegment.ByParentAndName((org.hibernate.Session)session, (DbAuthority)parentAuthority, name);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return subSegment;
    }

    @Override
    public synchronized Authority getSubSegmentParentAuthority(SubSegment subSegment) throws StoreException {
        DbAuthority parentAuthority;
        log.trace((Object)"getSubSegmentParentAuthority()");
        if (subSegment == null) {
            throw new NullPointerException();
        }
        if (!(subSegment instanceof DbSubSegment)) {
            throw new StoreNotFoundException("Subsegment is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, subSegment);
            parentAuthority = ((DbSubSegment)subSegment).getParent();
            if (parentAuthority != null) {
                Hibernate.initialize((Object)parentAuthority);
            }
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return parentAuthority;
    }

    @Override
    public synchronized Authority getSubSegmentAuthority(SubSegment subSegment) throws StoreException {
        DbAuthority authority;
        log.trace((Object)"getSubSegmentAuthority()");
        if (subSegment == null) {
            throw new NullPointerException();
        }
        if (!(subSegment instanceof DbSubSegment)) {
            throw new StoreNotFoundException("Subsegment is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, subSegment);
            authority = ((DbSubSegment)subSegment).getAuthority();
            if (authority != null) {
                Hibernate.initialize((Object)authority);
            }
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return authority;
    }

    @Override
    public synchronized void resetStore() throws StoreException {
        log.trace((Object)"resetStore()");
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DbSubSegment.DeleteAll((org.hibernate.Session)session);
            DbAuthority.DeleteAll((org.hibernate.Session)session);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public synchronized Authority[] listAuthorities() throws StoreException {
        List<DbAuthority> authorities;
        log.trace((Object)"listAuthorities()");
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            authorities = DbAuthority.All((org.hibernate.Session)session);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        Authority[] result = new ArrayList<DbAuthority>(authorities).toArray(new Authority[authorities.size()]);
        log.trace((Object)"Done.");
        return result;
    }

    @Override
    public synchronized SubSegment[] listSubSegments() throws StoreException {
        List<DbSubSegment> subSegments;
        log.trace((Object)"listSubSegments()");
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            subSegments = DbSubSegment.All((org.hibernate.Session)session);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        SubSegment[] result = new ArrayList<DbSubSegment>(subSegments).toArray(new SubSegment[subSegments.size()]);
        log.trace((Object)"Done.");
        return result;
    }

    @Override
    public synchronized SubSegment[] getAuthoritySubSegments(Authority authority) throws StoreException {
        Set<DbSubSegment> subSegments;
        log.trace((Object)"getAuthoritySegments()");
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            subSegments = ((DbAuthority)authority).getSubSegments();
            Hibernate.initialize(subSegments);
            if (subSegments == null) {
                throw new StoreNotFoundException("Subsegments do not exist.");
            }
            session.getTransaction().commit();
        }
        catch (StoreException ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        SubSegment[] result = new ArrayList<DbSubSegment>(subSegments).toArray(new SubSegment[subSegments.size()]);
        log.trace((Object)"Done.");
        return result;
    }

    @Override
    public synchronized SubSegment[] getAuthorityChildSubSegments(Authority parent) throws StoreException {
        Set<DbSubSegment> subSegments;
        log.trace((Object)"getAuthorityChildSegments()");
        if (parent == null) {
            throw new NullPointerException();
        }
        if (!(parent instanceof DbAuthority)) {
            throw new StoreNotFoundException("Parent authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, parent);
            subSegments = ((DbAuthority)parent).getChildren();
            Hibernate.initialize(subSegments);
            if (subSegments == null) {
                throw new StoreNotFoundException("Subsegments do not exist.");
            }
            session.getTransaction().commit();
        }
        catch (StoreException ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        SubSegment[] result = new ArrayList<DbSubSegment>(subSegments).toArray(new SubSegment[subSegments.size()]);
        log.trace((Object)"Done.");
        return result;
    }

    @Override
    public synchronized SubSegment[] getSynonymSubSegments(Authority parent, Authority authority) throws StoreException {
        List<DbSubSegment> subSegments;
        log.trace((Object)"getSynonymSegments()");
        if (parent == null) {
            throw new NullPointerException();
        }
        if (!(parent instanceof DbAuthority)) {
            throw new StoreNotFoundException("Parent authority is not from this store.");
        }
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, parent);
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            subSegments = DbSubSegment.ByParentAndAuthority((org.hibernate.Session)session, (DbAuthority)parent, (DbAuthority)authority);
            Hibernate.initialize(subSegments);
            if (subSegments == null) {
                throw new StoreNotFoundException("Subsegments do not exist.");
            }
            session.getTransaction().commit();
        }
        catch (StoreException ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        SubSegment[] result = new ArrayList<DbSubSegment>(subSegments).toArray(new SubSegment[subSegments.size()]);
        log.trace((Object)"Done.");
        return result;
    }

    @Override
    public synchronized String[] getAuthorityQxris(Authority authority) throws StoreException {
        return this.getAuthorityQxris(authority, true, true);
    }

    @Override
    public synchronized String[] getAuthorityQxris(Authority authority, boolean reassignable, boolean persistent) throws StoreException {
        List<String> result;
        log.trace((Object)"getAuthorityQxris()");
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            result = this.getAuthorityQxris((org.hibernate.Session)session, (DbAuthority)authority, 1, reassignable, persistent);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return result.toArray(new String[result.size()]);
    }

    private synchronized List<String> getAuthorityQxris(org.hibernate.Session session, DbAuthority authority, int depth, boolean reassignable, boolean persistent) throws StoreException {
        if (depth > 30) {
            return new ArrayList<String>();
        }
        ArrayList<String> qxris = new ArrayList<String>();
        if (authority == null) {
            qxris.add("");
            return qxris;
        }
        DatabaseStore.reattach(session, authority);
        Set<DbSubSegment> subSegments = authority.getSubSegments();
        for (DbSubSegment subSegment : subSegments) {
            List<String> rets = this.getAuthorityQxris(session, subSegment.getParent(), depth + 1, reassignable, persistent);
            for (String ret : rets) {
                String subSegmentName = subSegment.getName();
                if (!reassignable && !subSegmentName.contains("!") || !persistent && subSegmentName.contains("!")) continue;
                qxris.add(ret + subSegment.getName());
            }
        }
        if (qxris.equals("")) {
            qxris.add("");
        }
        return qxris;
    }

    @Override
    public synchronized Authority localLookup(XRIAuthority authorityPath) throws StoreException {
        log.trace((Object)"localLookup()");
        Session session = this.getSessionFactory().getCurrentSession();
        DbAuthority authority = null;
        try {
            session.beginTransaction();
            LinkedList<String> subSegmentNames = new LinkedList<String>();
            while (authorityPath != null) {
                DbSubSegment rootSubSegment = DbSubSegment.RootByName((org.hibernate.Session)session, authorityPath.toString());
                if (rootSubSegment != null) {
                    authority = rootSubSegment.getAuthority();
                    break;
                }
                log.trace((Object)authorityPath.toString());
                if (authorityPath.getLastSubSegment() != null) {
                    subSegmentNames.addFirst(authorityPath.getLastSubSegment().toString());
                }
                authorityPath = authorityPath.getParent();
            }
            if (authority == null) {
                return null;
            }
            for (String subSegmentName : subSegmentNames) {
                DbSubSegment subSegment = DbSubSegment.ByParentAndName((org.hibernate.Session)session, authority, subSegmentName);
                if (subSegment == null) {
                    return null;
                }
                authority = subSegment.getAuthority();
            }
            Hibernate.initialize((Object)authority);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return authority;
    }

    @Override
    public synchronized void setStoreAttributes(Map<String, String> attributes) throws StoreException {
        log.trace((Object)"setStoreAttributes()");
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DbStoreData storeData = DbStoreData.Singleton((org.hibernate.Session)session);
            storeData.setAttributes(attributes);
            session.update((Object)storeData);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public synchronized Map<String, String> getStoreAttributes() throws StoreException {
        Map<String, String> attributes;
        log.trace((Object)"getStoreAttributes()");
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            attributes = DbStoreData.Singleton((org.hibernate.Session)session).getAttributes();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return attributes;
    }

    @Override
    public synchronized void setAuthorityAttributes(Authority authority, Map<String, String> attributes) throws StoreException {
        log.trace((Object)"setAuthorityAttributes()");
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            ((DbAuthority)authority).setAttributes(attributes);
            session.update((Object)authority);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public synchronized Map<String, String> getAuthorityAttributes(Authority authority) throws StoreException {
        log.trace((Object)"getAuthorityAttributes()");
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        Map<String, String> attributes = ((DbAuthority)authority).getAttributes();
        log.trace((Object)"Done.");
        return attributes;
    }

    @Override
    public synchronized void setAuthorityIndex(Authority authority, String indx) throws StoreException {
        log.trace((Object)("setAuthorityIndex(" + indx + ")"));
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            ((DbAuthority)authority).setIndx(indx);
            session.update((Object)authority);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public synchronized String getAuthorityIndex(Authority authority) throws StoreException {
        log.trace((Object)"getAuthorityIndex()");
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        String indx = ((DbAuthority)authority).getIndx();
        log.trace((Object)"Done.");
        return indx;
    }

    @Override
    public synchronized void setSubSegmentAttributes(SubSegment subSegment, Map<String, String> attributes) throws StoreException {
        log.trace((Object)"setSubSegmentAttributes()");
        if (subSegment == null) {
            throw new NullPointerException();
        }
        if (!(subSegment instanceof DbSubSegment)) {
            throw new StoreNotFoundException("Subsegment is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            ((DbSubSegment)subSegment).setAttributes(attributes);
            session.update((Object)subSegment);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public synchronized Map<String, String> getSubSegmentAttributes(SubSegment subSegment) throws StoreException {
        log.trace((Object)"getSubSegmentAttributes()");
        if (subSegment == null) {
            throw new NullPointerException();
        }
        if (!(subSegment instanceof DbSubSegment)) {
            throw new StoreNotFoundException("Subsegment is not from this store.");
        }
        Map<String, String> attributes = ((DbSubSegment)subSegment).getAttributes();
        log.trace((Object)"Done.");
        return attributes;
    }

    @Override
    public synchronized void setSubSegmentIndex(SubSegment subSegment, String indx) throws StoreException {
        log.trace((Object)("setSubSegmentIndex(" + indx + ")"));
        if (subSegment == null) {
            throw new NullPointerException();
        }
        if (!(subSegment instanceof DbSubSegment)) {
            throw new StoreNotFoundException("Subsegment is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, subSegment);
            ((DbSubSegment)subSegment).setIndx(indx);
            session.update((Object)subSegment);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public synchronized String getSubSegmentIndex(SubSegment subSegment) throws StoreException {
        log.trace((Object)"getSubSegmentIndex()");
        if (subSegment == null) {
            throw new NullPointerException();
        }
        if (!(subSegment instanceof DbSubSegment)) {
            throw new StoreNotFoundException("Subsegment is not from this store.");
        }
        String indx = ((DbSubSegment)subSegment).getIndx();
        log.trace((Object)"Done.");
        return indx;
    }

    @Override
    public synchronized Authority[] listAuthoritiesByAttributes(StoreAttributable.Selector selector) throws StoreException {
        log.trace((Object)"listAuthoritiesByAttributes()");
        Session session = this.getSessionFactory().getCurrentSession();
        ArrayList<DbAuthority> selectedAuthorities = new ArrayList<DbAuthority>();
        try {
            session.beginTransaction();
            List<DbAuthority> authorities = DbAuthority.All((org.hibernate.Session)session);
            for (DbAuthority Authority2 : authorities) {
                if (!selector.select(Authority2.getAttributes())) continue;
                selectedAuthorities.add(Authority2);
            }
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return selectedAuthorities.toArray(new Authority[selectedAuthorities.size()]);
    }

    @Override
    public synchronized SubSegment[] listSubSegmentsByAttributes(StoreAttributable.Selector selector) throws StoreException {
        log.trace((Object)"listSubSegmentsByAttributes()");
        Session session = this.getSessionFactory().getCurrentSession();
        ArrayList<DbSubSegment> selectedSubSegments = new ArrayList<DbSubSegment>();
        try {
            session.beginTransaction();
            List<DbSubSegment> subSegments = DbSubSegment.All((org.hibernate.Session)session);
            for (DbSubSegment subSegment : subSegments) {
                if (!selector.select(subSegment.getAttributes())) continue;
                selectedSubSegments.add(subSegment);
            }
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return selectedSubSegments.toArray(new SubSegment[selectedSubSegments.size()]);
    }

    @Override
    public synchronized Authority[] listAuthoritiesByAttributeValue(String key, String value) throws StoreException {
        List<DbAuthority> authorities;
        log.trace((Object)("listAuthoritiesByAttributeValue(" + key + ", " + value + ")"));
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            authorities = DbAuthority.ByAttributeValue((org.hibernate.Session)session, key, value);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return authorities.toArray(new Authority[authorities.size()]);
    }

    @Override
    public synchronized SubSegment[] listSubSegmentsByAttributeValue(String key, String value) throws StoreException {
        List<DbSubSegment> subSegments;
        log.trace((Object)("listSubSegmentsByAttributeValue(" + key + ", " + value + ")"));
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            subSegments = DbSubSegment.ByAttributeValue((org.hibernate.Session)session, key, value);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return subSegments.toArray(new SubSegment[subSegments.size()]);
    }

    @Override
    public synchronized Authority[] listAuthoritiesByIndex(String indx) throws StoreException {
        List<DbAuthority> authorities;
        log.trace((Object)("listAuthoritiesByIndex(" + indx + ")"));
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            authorities = DbAuthority.AllByIndx((org.hibernate.Session)session, indx);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return authorities.toArray(new Authority[authorities.size()]);
    }

    @Override
    public synchronized SubSegment[] listSubSegmentsByIndex(String indx) throws StoreException {
        List<DbSubSegment> subSegments;
        log.trace((Object)("listSubSegmentsByIndex(" + indx + ")"));
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            subSegments = DbSubSegment.AllByIndx((org.hibernate.Session)session, indx);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return subSegments.toArray(new SubSegment[subSegments.size()]);
    }

    @Override
    public synchronized void setXrd(Authority authority, XRD xrd) throws StoreException {
        log.trace((Object)"setXrd()");
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            ((DbAuthority)authority).setXrd(xrd);
            session.update((Object)authority);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public void setAuthorityPath(Authority authority, String path) throws StoreException {
        log.trace((Object)("mount(" + path + ", " + authority.getId() + ")"));
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            DatabaseStore.reattach((org.hibernate.Session)session, authority);
            ((DbAuthority)authority).setPath(path);
            session.update((Object)authority);
            session.flush();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
    }

    @Override
    public String getAuthorityPath(Authority authority) throws StoreException {
        log.trace((Object)"getAuthorityPath()");
        if (authority == null) {
            throw new NullPointerException();
        }
        if (!(authority instanceof DbAuthority)) {
            throw new StoreNotFoundException("Authority is not from this store.");
        }
        String path = ((DbAuthority)authority).getPath();
        log.trace((Object)"Done.");
        return path;
    }

    @Override
    public Authority[] listAuthoritiesByPath(String path) throws StoreException {
        List<DbAuthority> authorities;
        log.trace((Object)("listAuthoritiesByPath(" + path + ")"));
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            authorities = DbAuthority.AllByPath((org.hibernate.Session)session, path);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return authorities.toArray(new Authority[authorities.size()]);
    }

    @Override
    public synchronized Long getAuthorityCount() throws StoreException {
        Long count;
        log.trace((Object)"getAuthorityCount()");
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            count = DbAuthority.Count((org.hibernate.Session)session);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return count;
    }

    @Override
    public synchronized Long getSubSegmentCount() throws StoreException {
        Long count;
        log.trace((Object)"getSubSegmentCount()");
        Session session = this.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            count = DbSubSegment.Count((org.hibernate.Session)session);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            DatabaseStore.rollback((org.hibernate.Session)session);
            throw new StoreInternalException(ex, "Cannot access database.");
        }
        log.trace((Object)"Done.");
        return count;
    }

    private static void reattach(org.hibernate.Session session, Object object) {
        if (object == null || session.contains(object)) {
            return;
        }
        session.lock(object, LockMode.READ);
    }

    private static void rollback(org.hibernate.Session session) {
        try {
            if (session.isOpen() && session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
        }
        catch (Exception ex) {
            log.warn((Object)"", (Throwable)ex);
        }
    }
}

