/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xri3.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openxri.xri3.XRI;
import org.openxri.xri3.XRIAuthority;
import org.openxri.xri3.XRIFragment;
import org.openxri.xri3.XRIPath;
import org.openxri.xri3.XRIQuery;
import org.openxri.xri3.XRIReference;
import org.openxri.xri3.XRISyntaxComponent;
import org.openxri.xri3.impl.XRI3Authority;
import org.openxri.xri3.impl.XRI3Fragment;
import org.openxri.xri3.impl.XRI3Path;
import org.openxri.xri3.impl.XRI3Query;
import org.openxri.xri3.impl.XRI3Reference;
import org.openxri.xri3.impl.XRI3SubSegment;
import org.openxri.xri3.impl.XRI3SyntaxComponent;
import org.openxri.xri3.impl.XRI3Util;
import org.openxri.xri3.impl.parser.Parser;
import org.openxri.xri3.impl.parser.ParserException;
import org.openxri.xri3.impl.parser.Rule;

public class XRI3
extends XRI3SyntaxComponent
implements XRI {
    private static final long serialVersionUID = 1556756335913091713L;
    private static final Set reserved = new HashSet<String>(Arrays.asList("user", "users", "individual", "individuals", "person", "persons", "personal", "personal.name", "personal.names", "organization", "organizations", "organizational", "organizational.name", "organizational.names", "name", "names", "iname", "inames", "i-name", "i-names", "i.name", "i.names", "number", "numbers", "inumber", "inumbers", "i-number", "i-numbers", "i.number", "i.numbers", "broker", "brokers", "i-broker", "i-brokers", "i.broker", "i.brokers", "gsp", "grsp", "global.service", "global.services", "global.service.provider", "global.service.providers", "public", "trust", "federation", "federations", "global", "service", "services", "provider", "providers", "registry", "registries", "registrant", "registrants", "aero", "biz", "cat", "com", "coop", "info", "jobs", "mobi", "museum", "net", "org", "pro", "travel", "gov", "edu", "mil", "int", "www", "ftp", "mail", "xdi", "xdiorg", "xdi-org", "xdi.org", "xri", "xriorg", "xri-org", "xri.org", "xri.xdi", "xdi.xri", "xri-xdi", "xdi-xri", "itrust", "i-trust", "i.trust", "cordance", "cordance.corp", "cordance.corporation", "cordance.net"));
    private Rule rule;
    private XRI3Authority authority;
    private XRI3Path path;
    private XRI3Query query;
    private XRI3Fragment fragment;

    public XRI3(String string) throws ParserException {
        this.rule = XRI3Util.getParser().parse("xri", string);
        this.read();
    }

    public XRI3(XRI xri2, XRISyntaxComponent xriPart) throws ParserException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(xri2.toString());
        buffer.append(xriPart.toString());
        this.rule = XRI3Util.getParser().parse("xri", buffer.toString());
        this.read();
    }

    public XRI3(XRI xri2, String xriPart) throws ParserException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(xri2.toString());
        buffer.append(xriPart);
        this.rule = XRI3Util.getParser().parse("xri", buffer.toString());
        this.read();
    }

    public XRI3(Character gcs, String uri) throws ParserException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(gcs.toString());
        buffer.append("(");
        buffer.append(uri);
        buffer.append(")");
        this.rule = XRI3Util.getParser().parse("xri", buffer.toString());
        this.read();
    }

    XRI3(Rule rule) {
        this.rule = rule;
        this.read();
    }

    private void reset() {
        this.authority = null;
        this.path = null;
        this.query = null;
        this.fragment = null;
    }

    private void read() {
        this.reset();
        Rule object = this.rule;
        ArrayList list_xri_noscheme = ((Parser.xri)object).rules;
        if (list_xri_noscheme.size() < 1) {
            return;
        }
        object = list_xri_noscheme.get(0);
        ArrayList list_xri_hier_part = ((Parser.xri_hier_part)object).rules;
        if (list_xri_hier_part.size() < 1) {
            return;
        }
        object = list_xri_hier_part.get(0);
        this.authority = new XRI3Authority((Parser.xri_authority)object);
        if (this.authority.getParserObject().spelling.length() < 1) {
            this.authority = null;
        }
        if (list_xri_hier_part.size() < 2) {
            return;
        }
        object = list_xri_hier_part.get(1);
        this.path = new XRI3Path((Parser.xri_path_abempty)object);
        if (this.path.getParserObject().spelling.length() < 1) {
            this.path = null;
        }
        if (list_xri_noscheme.size() < 3) {
            return;
        }
        object = list_xri_noscheme.get(2);
        if (object instanceof Parser.iquery) {
            this.query = new XRI3Query((Parser.iquery)object);
            if (this.query.getParserObject().spelling.length() < 1) {
                this.query = null;
            }
            if (list_xri_noscheme.size() < 5) {
                return;
            }
            object = list_xri_noscheme.get(4);
            this.fragment = new XRI3Fragment((Parser.ifragment)object);
            if (this.fragment.getParserObject().spelling.length() < 1) {
                this.fragment = null;
            }
        } else if (object instanceof Parser.ifragment) {
            this.fragment = new XRI3Fragment((Parser.ifragment)object);
            if (this.fragment.getParserObject().spelling.length() < 1) {
                this.fragment = null;
            }
        } else {
            throw new ClassCastException(object.getClass().getName());
        }
    }

    public Rule getParserObject() {
        return this.rule;
    }

    public boolean hasAuthority() {
        return this.authority != null;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public boolean hasQuery() {
        return this.query != null;
    }

    public boolean hasFragment() {
        return this.fragment != null;
    }

    public XRIAuthority getAuthority() {
        return this.authority;
    }

    public XRIPath getPath() {
        return this.path;
    }

    public XRIQuery getQuery() {
        return this.query;
    }

    public XRIFragment getFragment() {
        return this.fragment;
    }

    public boolean isIName() {
        List subSegments = this.authority.getSubSegments();
        for (int i = 0; i < subSegments.size(); ++i) {
            XRI3SubSegment subSegment = (XRI3SubSegment)subSegments.get(i);
            if (subSegment.isReassignable()) continue;
            return false;
        }
        String spelling = this.authority.toString();
        if (spelling.startsWith(".")) {
            return false;
        }
        if (spelling.endsWith(".")) {
            return false;
        }
        if (spelling.startsWith("-")) {
            return false;
        }
        if (spelling.endsWith("-")) {
            return false;
        }
        if (spelling.indexOf("..") >= 0) {
            return false;
        }
        if (spelling.indexOf("--") >= 0) {
            return false;
        }
        if (spelling.indexOf(".-") >= 0) {
            return false;
        }
        if (spelling.indexOf("-.") >= 0) {
            return false;
        }
        if (spelling.indexOf(37) >= 0) {
            return false;
        }
        if (spelling.indexOf(95) >= 0) {
            return false;
        }
        return spelling.length() <= 254;
    }

    public boolean isINumber() {
        List subSegments = this.authority.getSubSegments();
        for (int i = 0; i < subSegments.size(); ++i) {
            XRI3SubSegment subSegment = (XRI3SubSegment)subSegments.get(i);
            if (subSegment.isPersistent()) continue;
            return false;
        }
        return true;
    }

    public boolean isReserved() {
        String spelling = this.authority.toString();
        return reserved.contains(spelling.substring(1)) | reserved.contains(spelling.substring(1));
    }

    public String toIRINormalForm() {
        StringBuffer iri = new StringBuffer();
        if (this.authority != null) {
            iri.append("xri:");
            iri.append("").append(this.authority.toIRINormalForm());
        }
        if (this.path != null) {
            iri.append("/").append(this.path.toIRINormalForm());
        }
        if (this.query != null) {
            iri.append("?").append(this.query.toIRINormalForm());
        }
        if (this.fragment != null) {
            iri.append("#").append(this.fragment.toIRINormalForm());
        }
        return iri.toString();
    }

    public boolean isValidXRIReference() {
        XRIReference xriReference;
        try {
            xriReference = this.toXRIReference();
        }
        catch (Exception ex) {
            return false;
        }
        return xriReference != null;
    }

    public XRIReference toXRIReference() throws ParserException {
        return new XRI3Reference(this.toString());
    }

    public XRI3Reference toXRI3Reference() throws ParserException {
        return new XRI3Reference(this.toString());
    }

    public boolean startsWith(XRI xri2) {
        if (xri2.getAuthority() == null) {
            return true;
        }
        if (xri2.getAuthority() != null && this.getAuthority() == null) {
            return false;
        }
        if (!this.getAuthority().equals(xri2.getAuthority())) {
            return false;
        }
        if (xri2.getPath() == null) {
            return true;
        }
        if (xri2.getPath() != null && this.getPath() == null) {
            return false;
        }
        List thisSegments = this.getPath().getSegments();
        List xriSegments = xri2.getPath().getSegments();
        if (thisSegments.size() < xriSegments.size()) {
            return false;
        }
        for (int i = 0; i < xriSegments.size(); ++i) {
            if (thisSegments.get(i).equals(xriSegments.get(i))) continue;
            return false;
        }
        return true;
    }
}

