/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xri3.impl;

import java.util.ArrayList;
import org.openxri.xri3.XRIReference;
import org.openxri.xri3.XRIXRef;
import org.openxri.xri3.impl.XRI3Reference;
import org.openxri.xri3.impl.XRI3SyntaxComponent;
import org.openxri.xri3.impl.XRI3Util;
import org.openxri.xri3.impl.parser.Parser;
import org.openxri.xri3.impl.parser.ParserException;
import org.openxri.xri3.impl.parser.Rule;

public class XRI3XRef
extends XRI3SyntaxComponent
implements XRIXRef {
    private static final long serialVersionUID = 5499307555025868602L;
    private Rule rule;
    private XRI3Reference xriReference;
    private String iri;

    public XRI3XRef(String string) throws ParserException {
        this.rule = XRI3Util.getParser().parse("xref", string);
        this.read();
    }

    XRI3XRef(Rule rule) {
        this.rule = rule;
        this.read();
    }

    private void reset() {
        this.xriReference = null;
        this.iri = null;
    }

    private void read() {
        this.reset();
        Rule object = this.rule;
        if (object instanceof Parser.xref) {
            ArrayList list_xref = ((Parser.xref)object).rules;
            if (list_xref.size() < 1) {
                return;
            }
            object = list_xref.get(0);
        } else if (!(object instanceof Parser.xref_empty || object instanceof Parser.xref_xri_reference || object instanceof Parser.xref_IRI)) {
            throw new ClassCastException(object.getClass().getName());
        }
        if (!(object instanceof Parser.xref_empty)) {
            if (object instanceof Parser.xref_xri_reference) {
                ArrayList list_xref_xri_reference = ((Parser.xref_xri_reference)object).rules;
                if (list_xref_xri_reference.size() < 2) {
                    return;
                }
                object = list_xref_xri_reference.get(1);
                this.xriReference = new XRI3Reference((Parser.xri_reference)object);
            } else if (object instanceof Parser.xref_IRI) {
                ArrayList list_xref_IRI = ((Parser.xref_IRI)object).rules;
                if (list_xref_IRI.size() < 2) {
                    return;
                }
                object = list_xref_IRI.get(1);
                this.iri = ((Parser.IRI)object).spelling;
            } else {
                throw new ClassCastException(object.getClass().getName());
            }
        }
    }

    public Rule getParserObject() {
        return this.rule;
    }

    public boolean hasXRIReference() {
        return this.xriReference != null;
    }

    public boolean hasIRI() {
        return this.iri != null;
    }

    public XRIReference getXRIReference() {
        return this.xriReference;
    }

    public String getIRI() {
        return this.iri;
    }
}

