/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Arrays;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.TableScanResultSet;

class MultiProbeTableScanResultSet
extends TableScanResultSet
implements CursorResultSet {
    protected DataValueDescriptor[] probeValues;
    protected DataValueDescriptor[] origProbeValues;
    protected int probeValIndex;
    private boolean needSort;

    MultiProbeTableScanResultSet(long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, Activation activation, GeneratedMethod generatedMethod, int n, GeneratedMethod generatedMethod2, int n2, GeneratedMethod generatedMethod3, int n3, boolean bl, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray, boolean bl2, String string, String string2, String string3, boolean bl3, boolean bl4, int n4, int n5, int n6, boolean bl5, int n7, boolean bl6, double d, double d2) throws StandardException {
        super(l, staticCompiledOpenConglomInfo, activation, generatedMethod, n, generatedMethod2, n2, generatedMethod3, n3, bl, qualifierArray, string, string2, string3, bl3, bl4, n4, n5, n6, bl5, n7, 1, bl6, d, d2);
        this.origProbeValues = dataValueDescriptorArray;
        this.needSort = !bl2;
    }

    public void openCore() throws StandardException {
        if (this.needSort) {
            Object[] objectArray = new DataValueDescriptor[this.origProbeValues.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.origProbeValues[i].getClone();
            }
            Arrays.sort(objectArray);
            this.probeValues = objectArray;
        } else {
            this.probeValues = this.origProbeValues;
        }
        this.probeValIndex = 0;
        super.openCore();
    }

    protected void openScanController(TransactionController transactionController) throws StandardException {
        this.openScanController(transactionController, this.probeValues[0]);
        this.probeValIndex = 1;
    }

    public void reopenCore() throws StandardException {
        if (this.probeValIndex >= this.probeValues.length) {
            this.probeValIndex = 0;
        }
        super.reopenCore();
    }

    protected void reopenScanController() throws StandardException {
        if (this.probeValIndex == 0) {
            this.rowsThisScan = 0L;
        }
        DataValueDescriptor dataValueDescriptor = null;
        if (this.moreInListVals() && (dataValueDescriptor = this.getNextProbeValue()) == null) {
            return;
        }
        this.reopenScanController(dataValueDescriptor);
    }

    public ExecRow getNextRowCore() throws StandardException {
        this.checkCancellationFlag();
        ExecRow execRow = super.getNextRowCore();
        while (execRow == null && this.moreInListVals()) {
            this.reopenCore();
            execRow = super.getNextRowCore();
        }
        return execRow;
    }

    public void close() throws StandardException {
        super.close();
    }

    private boolean moreInListVals() {
        return this.probeValIndex < this.probeValues.length;
    }

    private DataValueDescriptor getNextProbeValue() throws StandardException {
        int n;
        for (n = this.probeValIndex; n > 0 && n < this.probeValues.length && this.probeValues[this.probeValIndex - 1].equals(this.probeValues[n]); ++n) {
        }
        this.probeValIndex = n;
        if (this.probeValIndex < this.probeValues.length) {
            return this.probeValues[this.probeValIndex++];
        }
        return null;
    }
}

