/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.openxri.AuthorityPath;
import org.openxri.IRIUtils;
import org.openxri.ParseStream;

public class IRIAuthority
extends AuthorityPath {
    private URI moURI = null;

    public IRIAuthority(String sPath) {
        super(sPath);
        this.parse();
    }

    IRIAuthority() {
    }

    public String getIUserInfo() {
        return this.moURI.getUserInfo();
    }

    public String getIHost() {
        return this.moURI.getHost();
    }

    public int getPort() {
        return this.moURI.getPort();
    }

    boolean doScan(ParseStream oStream) {
        boolean bVal = false;
        int n = this.scanChars(oStream.getData());
        String sData = oStream.getData().substring(0, n);
        try {
            this.moURI = new URI("http", sData, null, null, null);
            String sHost = this.moURI.getHost();
            if (sHost != null && sHost.length() > 0) {
                char cFirst = sHost.charAt(0);
                boolean bCheckIP = Character.isDigit(cFirst) || cFirst == '[';
                bVal = bCheckIP ? this.verifyIP(sHost) : this.verifyDNS(sHost);
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (bVal) {
            oStream.consume(n);
            return true;
        }
        return false;
    }

    private boolean verifyDNS(String sHost) {
        return true;
    }

    private boolean verifyIP(String sIP) {
        try {
            InetAddress oAddr = InetAddress.getByName(sIP);
            return oAddr != null;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    private int scanChars(String s) {
        block3: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '#': 
                case ')': 
                case '/': 
                case '?': {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            return i;
        }
        return s.length();
    }

    public String toIRINormalForm() {
        return IRIUtils.XRItoIRI(this.toString(), false);
    }

    public String toURINormalForm() {
        return IRIUtils.IRItoURI(this.toIRINormalForm());
    }
}

